/**
 * \file /output/ods/ptm/ptmgroupingsheet.h
 * \date 21/07/2025
 * \author Olivier Langella
 * \brief ODS PTM grouping sheet
 */

/*******************************************************************************
 * Copyright (c) 2025 Olivier Langella <olivier.langella@u-psud.fr>.
 *
 * This file is part of i2MassChroQ.
 *
 *     i2MassChroQ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     i2MassChroQ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with i2MassChroQ.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <olivier.langella@u-psud.fr> - initial API and
 *implementation
 ******************************************************************************/

#pragma once

#include "../../../core/project.h"
#include <odsstream/calcwriterinterface.h>
#include "../odsexport.h"
/**
 * @todo write docs
 */
class PtmGroupingSheet
{
  public:
  /**
   * Default constructor
   */
  PtmGroupingSheet(OdsExport *p_ods_export,
                   CalcWriterInterface *p_writer,
                   const Project *p_project);

  /**
   * Destructor
   */
  virtual ~PtmGroupingSheet();


  private:
  OdsExport *mp_odsExport;
  const Project *mp_project;
  CalcWriterInterface *mp_writer;
  const PtmGroupingExperiment *mp_ptmGroupingExperiment;
};
