/**
 * \file output/ods/ptm/comparptmislandsheet.h
 * \date 31/03/2025
 * \author Olivier Langella
 * \brief export compar ptm island datasheet
 */

/*******************************************************************************
 * Copyright (c) 2025 Olivier Langella
 *<Olivier.Langella@universite-paris-saclay.fr>.
 *
 * This file is part of MassChroQ.
 *
 *     MassChroQ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     MassChroQ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with MassChroQ.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/


#pragma once

#include "../../../core/project.h"
#include <odsstream/calcwriterinterface.h>
#include "../../../grouping/ptm/ptmisland.h"
#include "../odsexport.h"
#include "../../../gui/ptm_island_list_view/ptmislandtablemodel.h"

class ComparPtmIslandSheet
{
  public:
  ComparPtmIslandSheet(OdsExport *p_ods_export,
                 CalcWriterInterface *p_writer,
                 const Project *p_project);
  
  virtual ~ComparPtmIslandSheet();

  private:
  void writeIdentificationGroup(IdentificationGroup *p_ident);
  void writeHeaders(IdentificationGroup *p_ident);
  void writeOnePtmIsland(PtmIslandSp &sp_ptm_island);

  protected:
  void writeCellHeader(PtmIslandListColumn column);

  private:
  OdsExport *_p_ods_export;
  const Project *_p_project;
  CalcWriterInterface *mp_calcWriterInterface;
  const PtmGroupingExperiment *_p_ptm_grouping_experiment;
  LabelingMethodSp msp_labelingMethod;

  std::vector<Label *> m_labelPtrList;
  std::vector<MsRunSp> m_currentMsRunSpList;
};
