/**
 * \file mcql/input/cborstreamreaderdebugquantificationdata.cpp
 * \date 17/01/2025
 * \author Olivier Langella
 * \brief read cbor stream to extract given quantified petpides
 */

/*******************************************************************************
 * Copyright (c) 2025 Olivier Langella
 *<Olivier.Langella@universite-paris-saclay.fr>.
 *
 * This file is part of MassChroQ.
 *
 *     MassChroQ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     MassChroQ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with MassChroQ.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/

#include "cborstreamreaderdebugquantificationdata.h"

#include <pappsomspp/core/pappsoexception.h>
#include <pappsomspp/core/exception/exceptionnotfound.h>

mcql::CborStreamReaderDebugQuantificationData::
  CborStreamReaderDebugQuantificationData()
{
}

mcql::CborStreamReaderDebugQuantificationData::
  ~CborStreamReaderDebugQuantificationData()
{
}

void
mcql::CborStreamReaderDebugQuantificationData::setFindPeptideIdList(
  const QStringList &peptide_id)
{
  m_findPeptideIdList = peptide_id;
}

const QJsonObject &
mcql::CborStreamReaderDebugQuantificationData::getJsonObject()
{
  return m_jsonRoot;
}

void
mcql::CborStreamReaderDebugQuantificationData::readIdentificationData(
  pappso::UiMonitorInterface &monitor)
{

  mpa_cborReader->enterContainer(); // map
  std::size_t i = 0;
  while(getExpectedString())
    {
      qDebug() << m_expectedString;
      if(m_expectedString == "msrun_list")
        {
          QCborMap msrun_list;
          mpa_cborReader->readCborMap(msrun_list);

          m_jsonRoot.insert("msrun_list", QCborValue(msrun_list).toJsonValue());
        }
      else
        {
          mpa_cborReader->next();
        }
    }
  mpa_cborReader->leaveContainer();
}


void
mcql::CborStreamReaderDebugQuantificationData::readPeptideMeasurements(
  pappso::UiMonitorInterface &monitor)
{

  qDebug() << mpa_cborReader->length();
  monitor.setTotalSteps(mpa_cborReader->length());


  if(!mpa_cborReader->isLengthKnown())
    {
      throw pappso::PappsoException(
        QObject::tr(
          "ERROR: peptide_measurements map size not known in peptideid %3")
          .arg(m_peptideId));
    }

  std::size_t size = mpa_cborReader->length();
  mpa_cborReader->enterContainer(); // map
  std::size_t i = 0;
  while(getExpectedString())
    {
      qDebug() << m_expectedString;
      m_peptideId = m_expectedString;

      if(m_findPeptideIdList.contains(m_peptideId))
        {

          QCborMap peptide_measurement;
          mpa_cborReader->readCborMap(peptide_measurement);

          peptide_measurement.insert(QString("msrun"), m_msrunId);
          peptide_measurement.insert(QString("group"), m_groupId);

          auto it_map = m_peptideMeasurementDataMap.insert(
            {m_peptideId, std::vector<QCborMap>()});

          it_map.first->second.push_back(peptide_measurement);
        }
      else
        {
          mpa_cborReader->next();
        }
      i++;
      // mpa_cborReader->next();
    }

  qDebug() << size << " " << i;
  if(i < size)
    {
      throw pappso::PappsoException(
        QObject::tr("ERROR: only %1 peptide_measurements out of %2 expected, "
                    "peptideid %3")
          .arg(i)
          .arg(size)
          .arg(m_peptideId));
    }
  mpa_cborReader->leaveContainer();
  qDebug() << size;
}


void
mcql::CborStreamReaderDebugQuantificationData::readEnd(
  pappso::UiMonitorInterface &monitor)
{
  QJsonObject peptide_map;

  for(auto &it_pair : m_peptideMeasurementDataMap)
    {
      QString peptide_id = it_pair.first;
      QJsonArray measurement_list;
      for(auto &peptide_measurement : it_pair.second)
        {
          measurement_list.append(
            QCborValue(peptide_measurement).toJsonValue());
        }
      peptide_map.insert(peptide_id, measurement_list);
    }

  m_jsonRoot.insert("quantification_data", peptide_map);
}
