// import the package
#import "@preview/i-figured:0.2.4"

#set text(fallback: false)
#let main-color = rgb("#993300")

#let conf(
  subtitle: none,
  authors: (),
  toc: true,
  lang: "en",
  font: "PT Sans",
  date: none,
  years: (2024, 2025),
  version: none,
  title,
  doc,
) = {
  
  // apply the show rules (these can be customized)
  show heading: i-figured.reset-counters
  show figure: i-figured.show-figure

  show figure.caption: it => [
    #set par(leading: 0.7em, justify: false)
    #set align(left)
    #text(fill: main-color, style: "normal", weight: "medium", smallcaps( it))
  ]
  

  show figure : it => [
    //#set block(width: 90%,)
    #set par( leading: 0.5em, justify: true)
    #text( weight: "thin",style: "normal", it)
  ]

  set heading(numbering: "1.1")
  show heading.where(level: 1):  it => [
    #pagebreak()
    #set par(justify:false)
    #pad(
      top: 6pt,
      text(fill: main-color, weight: "medium", size: 20pt ,smallcaps( it))
    )
  ]
  
  show heading.where(level: 2):  it => [
    #set par(justify:false)
    #pad(
      top: 6pt,
      text(fill: main-color, weight: "medium", size: 20pt ,smallcaps(it))
    )
  ]
  
  show heading.where(level: 3):  it => [
    #set par(justify:false)
    #pad(
      top: 6pt,
      text(fill: main-color, weight: "medium", size: 16pt ,smallcaps(it))
    )
  ]
  
  show heading.where(level: 4):  it => [
    #set par(justify:false)
    #pad(
      top: 6pt,
      text(fill: main-color, weight: "medium", size: 14pt ,smallcaps(it))
    )
  ]
  

  show ref: it => {
    show link: it => {
      show text: body => {
        set text(fill: rgb("#993300"))
        smallcaps(body)
      }
      it
    }
    let el = it.element
    if el != none and el.func() == figure  and el.kind == "caution" {
      link(el.location(),el.supplement)
    } else if el != none and el.func() == figure {
      link(el.location(),box(el.caption))
    } else {
      link(el.location(),it)
    }
  }

  
  
  set text(lang: lang, font: font, fallback: false)
  set par(
	  justify: true,
	  leading: 1em,
	  spacing: 1.5em
  )
  show heading: set block(below: 2em)
  
  set list(spacing: 2em, indent: 2em, body-indent: 0.5em,marker: box(height: 0.65em, align(horizon+center, text(fill: main-color, size: 3em)[•])))

  
  v(32pt)
  align(center)[#image("assets/i2MassChroQ_icon.svg", width: 50%)]
  
  v(32pt)
  let count = authors.len()
  let ncols = 1
  if count > 3 {
      ncols = 2
  }
  v(32pt)

  align(center)[
    #line(length: 100%)
    #v(16pt)
    #text(size: 32pt, weight: "medium", fill: main-color)[#smallcaps(title)]\
    #v(16pt)
    #if (subtitle != none) {
      line(length: 10%)
      text(size: 18pt, weight: "medium", fill: main-color)[#smallcaps(subtitle)]
    }
    #line(length: 100%)
    #v(64pt)
    #text(20pt, str("version: ") + version)

    #align(bottom)[
      #grid(
        columns: (0.5fr,) * ncols,
        row-gutter: 12pt,
        ..authors.map(author => [
          #text(16pt, author.name) \
        ]
        ),
      )]
  ]

  pagebreak()
  set align(left)
 

  if toc {
  
    show outline.entry.where(
      level: 1
    ): it => {
      let el = it.element
      if el != none and el.func() == figure {
        text(fill: main-color, weight: "medium", size: 12pt ,smallcaps(it))
      } else {
        v(12pt, weak: true)
        text(fill: main-color, weight: "medium", size: 20pt ,smallcaps(it))
      }
    }
  
    set outline.entry(fill: none)

    outline(indent: 2em, depth: 2)

    i-figured.outline( title: [List of Figures])
  }
  set page(
    margin: (top: 42pt),
    header: [
      #set text(8pt)
      #smallcaps[#title]
      #if (date != none) {
        h(1fr) + text(date)
      }
      #line(length: 100%)
    ],
  )
  doc
}

#let c = counter("question")
#let question(title, counter: true) = context {
  v(8pt)
  if (counter) {
    c.step()
    heading(level: 2, c.display() + ") " + title)
  } else {
    heading(level: 2, title)
  }  
  v(4pt)
}

#let code-block(code, language, title: none) = {
  v(6pt)

  if (title != none) {
    text(10pt, style: "italic", title) 
    linebreak()
  }
  raw(code, lang: language)
  v(6pt)
}

#let remarque(content, bg-color: silver, text-color: black) = {
  v(4pt)
  block(
    fill: bg-color,
    width: 100%,
    inset: 8pt,
    radius: 4pt,
    text(10pt, content, fill: text-color)
  )
}


#let application(content) = {
  text(content, style: "italic")
}

#let productname(content) = {
  text(content, style: "italic")
}
#let productname-tm(content) = {
  text(content, style: "italic") + sym.trademark
}

#let command(content) = {
  text(underline(content), style: "normal", stroke: 0.5pt)
}

#let filename(content) = {
  text(content, style: "normal", font: "Liberation Mono")
}
#let filename_extension(content) = {
  text(content, style: "normal", font: "Liberation Mono")
}
#let filename_directory(content) = {
  text(content, style: "normal", font: "Liberation Mono")
}

#let foreignphrase(content) = {
  text(content, style: "italic")
}

#let guilabel(content) = {
  text(content, style: "italic")
}

#let guibutton(content) = {
  text(content, style: "italic")
}

#let guimenuitem(content) = {
  text(content, style: "italic")
}
#let guimenu(content) = {
  text(content, style: "italic")
}

#let keycap(content) = {
  " " + box(baseline: 15%, height: 1em,rect(stroke: gray, fill: rgb("#efeff0"),{
  set align(horizon)
  text(font: "Courier New", size: 0.8em, content)})) + " " 
}

#let mcq3 = emph("MassChroQ3")
#let mcq = emph("MassChroQ")
#let mss = emph("MSstats")
#let gnur = emph("GNU R")
#let vs = emph("vs")
#let mcqr = emph("MCQR")
#let i2mcq = emph("i2MassChroQ")
#let xtandem = emph("X!Tandem")
#let xtpjava = emph("X!TandemPipeline-Java")
#let xtpcpp = emph("X!TandemPipeline++")
#let nbsp = sym.space.nobreak
#let massXp = emph("massXpert")
#let mz = [m#sym.slash;z]
#let mzz = [m#sym.slash;z,z]
#let evalue = "E-value"
#let mh = [[M+H]#super[+]]
#let mnh = [[M+nH]#super[n+]]
#let ellipsis = "..."
#let bseries = emph("b")
#let yseries = emph("y")


#let block-tip(title: none, body) = grid(
  columns: (40pt, 90%),
  rows: (auto),
  gutter: 0pt,
  inset: 0pt,
    image("assets/idea-lamp-svgrepo-com.svg")
    ,box(width: 100%-40pt,{
        let tip-title = "Tip"
        if (title != none) {
          tip-title = tip-title + ": "+title
        }
        set align(left)
        block(text(fill: main-color, weight: "medium", size: 20pt)[#smallcaps(tip-title)])
        text(size: 1em)[#body]})
)


#let block-note(title: none, body) = grid(
  columns: (40pt, 90%),
  rows: (auto),
  gutter: 0pt,
  inset: 0pt,
    image("assets/clip-data-document-file-page-paper-svgrepo-com.svg")
    ,box(width: 100%-40pt,{
        
        let tip-title = "Note"
        if (title != none) {
          tip-title = tip-title + ": "+title
        }
        set align(left)
        block(text(fill: main-color, weight: "medium", size: 20pt)[#smallcaps(tip-title)])
        text(size: 1em)[#body]})
)


#let caution_ref_name(
    ref-name: "") = [
#smallcaps("Caution: "+ref-name)
]

#let block-caution(title: none, body) = figure(kind: "caution", supplement: caution_ref_name(ref-name: title), {
grid(
  columns: (40pt, 90%),
  rows: (auto),
  gutter: 0pt,
  inset: 0pt,
    image("assets/warning-round-svgrepo-com.svg")
    ,box(width: 100%-40pt,{
        let tip-title = "Caution"
        if (title != none) {
          tip-title = tip-title + ": "+title
        }
        set align(left)
        block(text(fill: main-color, weight: "medium", size: 20pt)[#smallcaps(tip-title)])
        text(size: 1em)[#body]})
)
})


= figure()

#let block-warning(title: none, body) = grid(
  columns: (40pt, 90%),
  rows: (auto),
  gutter: 0pt,
  inset: 0pt,
    image("assets/warning-alt-2-svgrepo-com.svg")
    ,box(width: 100%-40pt,{
        let tip-title = "Warning"
        if (title != none) {
          tip-title = tip-title + ": "+title
        }
        set align(left)
        block(text(fill: main-color, weight: "medium", size: 20pt)[#smallcaps(tip-title)])
        text(size: 1em)[#body]})
)


#let code-prompt(code,  title: none) = {
  
show raw.line: it => block(
  text( "$ " + it.body+" " + box(rect(inset: 3pt, height: 1em,radius: 5pt, fill: rgb("#a2aabc"))[#text(size: 0.5em,"RETURN")]))
)
  v(6pt)

  if (title != none) {
    text(10pt, style: "italic", title) 
    linebreak()
  }
  raw(code, lang: "bash")
  v(6pt)
}

#let code-block(code, language, title: none) = {
  if (title != none) {
    text(10pt, style: "italic", title) 
    linebreak()
  }
  
  set align(center)
  rect(inset: 3em, stroke: rgb("#afafaf"),fill: rgb("#f5f5f6"),{
    set align(left)
    set text(fill: rgb("#5c5c5d"))
    box(raw(code, lang: language))
  })
}

#let code-fasta(code) = {

  set align(center)
  rect(inset: 3em, stroke: rgb("#afafaf"),fill: rgb("#f5f5f6"),{
  set align(left)
  set text(fill: rgb("#5c5c5d"))
  box(raw(code, lang: "text"))
  })
}

#let code-raw(code) = {
  set text(fill: rgb("#5c5c5d"))
  raw(code, lang: "text")
}

 

#let linkext(location, content) = {
    show text: body => {
      set text(fill: rgb("#993300"))
      smallcaps(body)
    }
    link(location, content + box(image("assets/external-link-svgrepo-com.svg"),height:0.6em))
  }


#let formalpara(title, content) = {
  text(font: "Nimbus Sans", weight: "semibold", size: 1em)[#title] +"."+ h(1em) + content
}
