#import "../template.typ": *


= Advanced Proteomics Configurations

// <keyword>configurations</keyword>
//    <keyword>modifications</keyword>
//    <keyword>labeling</keyword>

This chapter describes in detail all the various advanced configurations that
  determine the workings of #i2mcq; in various contexts.


Some of the advanced proteomics configurations can only be carried over when
  protein identification results have been loaded in #i2mcq;. Indeed, only at
  that point, does the menu of the main program window show the submenus of
  interest, as shown in @fig:fig_xtpcpp-main-window-edit-menu-modifications.



#figure(
caption: [The #guimenu[Edit] menu showing various configuration
  tasks],
[
#image("../assets/print-xtpcpp-main-window-edit-menu-modifications.png")
This menu becomes available in the main program window only when
  identification data have been loaded in #i2mcq;
]
)<fig_xtpcpp-main-window-edit-menu-modifications>



== Configuring Modifications <sect_configuring-modifications>

It is often required to specify the chemistry of a given chemical
    modification that might be performed (or spontaneously observed ) on the
    proteins of a sample. For example, proteins in a sample often undergo a
    chemical modification of the cysteine residues in their reduced form to
    block them from reoxidizing into a sulphide bond. The reagent used is
    iodoacetamide and the reaction name is
    #emph[carbamidomethylation].

    

In order to be able to access the modifications configuration, select
    #guimenuitem[Modifications] from the #guimenuitem[Menu]
    menu. The window that opens up is shown in @fig:fig_xtpcpp-advanced-configuration-modification-editor-window-folded. In that #guilabel[Modifications editor] window, the currently
    defined modifications are listed with no details about them.



#figure(
caption: [Modifications editor window (folded)],
[
#image("../assets/print-xtpcpp-advanced-configuration-modification-editor-window-folded.png")
When the #guilabel[Modifications editor] window is
        displayed, all the modifications data are folded.
]
)<fig_xtpcpp-advanced-configuration-modification-editor-window-folded>



To start editing an existing modification, click the correponding item from the
  list, which opens up a #guilabel[Selected modification] group box
  widget, as shown in @fig:fig_xtpcpp-advanced-configuration-modification-editor-window-unfolded.



#figure(
caption: [Modifications editor window (unfolded)],
[
#image("../assets/print-xtpcpp-advanced-configuration-modification-editor-window-unfolded.png")
This view shows the details of the modification item currently
      selected.
]
)<fig_xtpcpp-advanced-configuration-modification-editor-window-unfolded>




The #guilabel[Modifications editor] window displays the details of
  the modification currently selected in the #guilabel[Modifications
  list]. The main informational data bits are the following:

/ accession: the PSI-MOD#footnote[The PSI-MOD
 ontology is perusable at #link("https://raw.githubusercontent.com/HUPO-PSI/psi-mod-CV/master/PSI-MOD.obo")] identificator. 
 This value matches the id field of the corresponding PSI-MOD ontology record (see an example below);

/ description: the description of the PSI-MOD entity.
      This value corresponds to the name field of the corresponding PSI-MOD
      ontology record;
      
/ mass delta: the net mass change that results from a
      protein modification using this modification entity.

      

#block-note(title: "A typical term definition from the PSI-MOD ontology")[

#let code_obo = read("../assets/obo_MOD397.txt")
#code-block(title: "", code_obo, "obo")
]


If a change, that is, a replacement, is required in the modification, the
  first step is to click onto the #guibutton[browse] button located
  in the #guilabel[Replace by] group box, which opens the
  #guilabel[PSI MOD selection] window shown in @fig:fig_xtpcpp-advanced-configuration-modification-editor-psi-mod-selection-window.

  

#figure(
caption: [PSI MOD selection window],
[
#image("../assets/print-xtpcpp-advanced-configuration-modification-editor-psi-mod-selection-window.png")
This window allows one to browse the PSI-MOD ontology on the basis
      of the modification net mass value.
]
)<fig_xtpcpp-advanced-configuration-modification-editor-psi-mod-selection-window>




The window shows the various PSI-MOD-defined ontology terms that match the net
  mass value of the modification that was selected when the
 #guibutton[browse] button was clicked. 


It is possible to search for other PSI-MOD terms that match a different net
  mass change by modifying the mass value in the spin box widget that is found
  under the control of the #guilabel[Mass filter] check box. The other
  spin box widget next to the first one allows one to enter the tolerance of the
  net mass change match. Available #quote[units] for that tolerance are
  Dalton, ppm and res.  

If the #guilabel[Mass filter] check box is unchecked, the list
  beneath it displays #emph[all] the PSI-MOD ontology terms.

Once the desired term has been found and selected, click the
  #guilabel[OK] button. In order to effectively replace the old term
  with the new one, do not forget to click the #guibutton[replace]
  button.



#block-tip(title: "Why bothering with PSI-MOD ontology modification terms ?")[
It is beneficial to define chemical modifications based on the PSI-MOD
    ontology terms because the defined modification is then used as its code
    (for example #emph[MOD:00397]) in the #xtandem; presets
    chemical modifications sections (see @sect_xtandem-parameter-presets). Indeed, instead of only
    entering the net mass, defining a modification preset with the PSI-MOD
    ontology term code allows #i2mcq; to compute a number of informative
    supplementary data. For example, when an isotopic cluster is simulated for a
    peptide that is modified with a PSI-MOD-documented modification, the formula
    of the modification recorded in the term is taken into account in the
    isotopic cluster calculation.
]



== Configuring Labeling Methods <sect_configuring-labeling-methods>

#i2mcq; can handle stable isotope labeling methods. In order to list the
    available methods, select the #guimenuitem[Labeling methods]
    menu item of the #guimenu[Edit] menu in the main program window.
    The #guilabel[Labeling methods editor] window that opens up is
    shown in @fig:fig_xtpcpp-advanced-configuration-labeling-methods-editor-window.


#figure(
caption: [Labeling methods editor window],
[
#image("../assets/print-xtpcpp-advanced-configuration-labeling-methods-editor-window.png")
This window lists all the available labeling methods.
]
)<fig_xtpcpp-advanced-configuration-labeling-methods-editor-window>



Configuring a labeling method is as easy as selecting one item from the
    list shown in @fig:fig_xtpcpp-advanced-configuration-labeling-methods-editor-window and clicking
    #guibutton[OK]. If unsure about the selection,
    just click #guibutton[Cancel].

#block-warning(title: "It is not possible to backstep")[
Once the user has clicked the #guibutton[OK] button, it is no
      more possible to change the labeling method without recomputing the whole
      data set.
]


Using a labeling method involves a crucial step during the &xtandem;
    configuration, as described in @sect_xtandem-parameter-presets and in @caution_phosphoproteomics-with-label-based-quantitation.
    Whenever an experiment involves chemical labeling of any protein residue,
    the scientist is expected to configure the labeling modifications in the
    #xtandem; presets before running it to search the database, so that the
    engine models correctly-modified peptides.

    
When the #xtandem; database search engine has finished identifying peptides
    and proteins, the modified peptides are only tagged using the modifications'
    net masses.  This is visible in the peptide details window shown in the
    upper left part of @fig:fig_xtpcpp-phospho-peptide-ms-ms-details-one-positive-phospho-site.
    There, one can see that the peptide is modified on its lysine 15 residue
    with one of the labels defined in the #guilabel[Fixed modifications 1] field of the presets configuration window shown
    in @fig:fig_xtpcpp-phospho-presets-residue-tab.

    
Selecting a labeling method, as described above, will allow #i2mcq; to
    report residue modifications in a much more detailed and informative way.
    For example, the name of the chemical modification will be used instead of
    the net mass change due to that modification. For this to happen and the
    effects to be visible, &i2mcq; goes back through all the identification
    process and makes sure that the modified peptides are tagged according to
    the modifications specified in the labeling method. The effects are visible
    in the #guilabel[XIC viewer] window as shown in @fig:fig_xtpcpp-xic-viewer-for-peptide-details-mod-code.

    

#figure(
caption: [Chemical modifications are tagged with their PSI-MOD code],
[
#image("../assets/print-xtpcpp-xic-viewer-for-peptide-details-mod-code.png")
When the user selects a labeling method from the list of available
        chemical modifications, the chemically modified residue gets an associated
        tag with the PSI-MOD code. This is visible in this figure, at the top
        line of the #guilabel[XIC viewer] window, where the last
        peptide's arginine residue is modified with
        #guilabel[MOD:00552], that corresponds to the #guilabel[4x(2)H
        labeled dimethylated residue] modification referenced in the
        #guilabel[Modification editor] window on the right hand side of
        this figure.
]
)<fig_xtpcpp-xic-viewer-for-peptide-details-mod-code>





== The #i2mcq; General Settings <sect_general-settings>

There are general settings that might be configured for the whole #i2mcq;
    program. These settings are available upon selecting the
    #guimenuitem[General settings] menu of the
    #guimenu[Edit] menu of the main program window. The window that
    opens up is shown in @fig:fig_xtpcpp-advanced-configuration-general-settings-window.



#figure(
caption: [General settings window],
[
#image("../assets/print-xtpcpp-advanced-configuration-general-settings-window.png")
General settings might be configured in this window, as described
        below.
]
)<fig_xtpcpp-advanced-configuration-general-settings-window>




The settings that can be configured are detailed below.

- #guilabel[MS run XIC reader settings]: if
        #guilabel[direct] is selected, the XIC chromatogram is
        computed by read the MS data right from the file; if
        #guilabel[buffered] is selected, the XIC chromatogram is
        computed by using a cache mechanism that buffers data in the computer's
        memory.
- #guilabel[R settings]: 
 - #guilabel[R binary path]: full path to the R program; 
 - #guilabel[Rscript binary path]: full path to the Rscript program;

- #guilabel[Bruker timsTOF settings]:  the fields below need
        filling-in if the data in the proteomics project originated in the
        Bruker's timsTOF line of instruments. 
 - #guilabel[Temporary directory]: optionally set the full
            path to the directory where the program stores temporary data;
 - #guilabel[Origin of the MS/MS data]: if
            #guilabel[MGF] is selected, the data are read from the Bruker-generated MGF file; if
            #guilabel[TDF] is selected, the data are read from the Bruker native TDF file.

#block-warning[
If the user selects the #guilabel[MGF] option above
                (because this is what they have), #i2mcq; will not be able to
                extract XIC chromatograms, because the MGF file format does not
                contain MS data, it contains only MS/MS data. If having the
                native TDF files at hand (in the .d directory), the user is
                advised to select #guilabel[TDF].
]

