#import "../template.typ": *

#figure([
#image("../assets/xtpcpp-peptide-mass-spectrum-match-process.svg")
#let block = block.with(inset: 0pt)
#block[#rect(radius: 1em, stroke: 0.5pt, fill: rgb("#e5e5e4"))[
X!Tandem HyperScore: #box(baseline: 40%,)[
$
(sum_(i=1)^n I_i P_i) N_b !  N_y !
$]
#set align(left)
/ #box(width: 1.6em)[$n$]: number of peak matches between the experimental and theoretical spectra
/ #box(width: 1.6em)[$I_i$]: intensity of the considered experimental peak
/ #box(width: 1.6em)[$P_i$]: ponderation of the considered experimental peak
/ #box(width: 1.6em)[$N_b !$]:factorial of the number of matched peaks of the b ion series
/ #box(width: 1.6em)[$N_y !$]: factorial of the number of matched peaks of the y ion series]]
#block[#text(size: 1.8em)[H-S yyy >> H-S xxx >> H-s zzz]]


The process starts with a full scan mass spectrum from which the mass
        spectrometer selects one precursor ion at a definite #mz; value. That
        ion is fragmented and thus generates a MS/MS spectrum. During the data
        exploration, the software extracts from the database all the peptides
        having the same #mz; value as that of the fragmented ion (top right,
        violet background). Next, the experimental MS/MS spectrum is compared in
        turn to each one of the MS/MS spectra of the extracted peptide list. A
        HyperScore is computed at each comparison.  Because #i2mcq; uses
        #xtandem; as its preferred protein database search engine, the
        HyperScore calculation, as performed by #xtandem;, is described.
]
, caption: [The steps leading to a scored peptide #vs; mass spectrum match (PSM)]
)<fig_xtpcpp-peptide-mass-spectrum-match-process>
