#import "@preview/alchemist:0.1.5": *

#let molecule-R1 = draw-skeleton(name: "mol1",mol-anchor: "east", {
  molecule(name: "A", "H_2N")
  single()
  molecule(name: "B", "CH")
  branch({
    single(angle: 6,from: 0)
    molecule(
      "R_1",
    )
  })
  single()
  molecule(name: "C", "COOH")
  })
  
  
#let molecule-R2 = draw-skeleton(name: "mol2",mol-anchor: "west",{
  molecule(name: "BA", "H_2N")
  single()
  molecule(name: "BB", "CH")
  branch({
    single(angle: 6,from: 0)
    molecule(
      "R_2",
    )
  })
  single()
  molecule(name: "BC", "COOH")
  })

#let molecule-eau = draw-skeleton(name: "eau",mol-anchor: "west",{
  molecule(name: "eau", "H_2O")
})

#let molecule-bas = draw-skeleton(name: "bas",mol-anchor: "north",{
  molecule(name: "BA", "H_2N")
  single()
  molecule(name: "BB", "CH")
  branch({
    single(angle: 6,from: 0)
    molecule(
      "R_1",
    )
  })
  single()
  molecule(name: "BC", "CO")
  single(stroke: blue)
  molecule("NH")
  single()
  molecule("CH")
  branch({
    single(angle: 6,from: 0)
    molecule("R_2")
  })
  single()
  molecule("COOH")
  })

#figure([
#cetz.canvas({
import cetz.draw: *
group(name: "haut", anchor:"south",{
molecule-R1
set-origin((rel: (1em, 0)))
molecule-R2
hobby(
(to: "mol1.C.0.north", rel: (0, 1pt)),
("mol1.C.0.north", 1, 30deg, "mol2.BA.1.north"),
(to: "mol2.BA.1.north", rel: (0, 1pt)),
mark: (end: ">", start: ">"),
stroke: red,
)
}
)
line(name: "reaction",(to: "haut.south", rel: (0,1em)), (rel: (0,-2)), mark: (end: ">"))
hobby(
(to: "reaction.start", rel: (0,-0.5)),
("reaction.start", 1, -20deg, (to: "reaction.centroid", rel: (1,0))),
(to: "reaction.centroid", rel: (1,0)),
mark: (end: ">"),
)
set-origin((to: "haut.south", rel: (0,-2)))
molecule-bas
set-origin((to: "reaction.centroid", rel: (1,0)))
molecule-eau
})

The left end monomer $R_1$ is condensed to
          the right end monomer $R_2$ to yield a
          peptidic bond. A water molecule is lost during the process.
],
  caption: [Peptidic Bond Formation by Condensation],
) <fig_xtpcpp-peptide-bond-formation>

