#import "../template.typ": *

#set heading(outlined: false)

#show heading:  it => [
    #set par(justify:false)
    #pad(
      top: 6pt,
      text(fill: main-color, weight: "medium", size: 20pt ,smallcaps( it.body))
    )
  ]
  
= Preface
    
== Software feature offerings and intended audience

This manual is about the #i2mcq protein identification software project.

#i2mcq has the following features:


- Load mass spectometry data files in the mzXML or mzML format, thanks to the excellent #application[libpwiz] library of ProteoWizard #footnote[#linkext("http://proteowizard.sourceforge.net/", "http://proteowizard.sourceforge.net/")] fame.
- Configure the way the peptide/mass spectrum matches (PSM) are to be performed;
- Configure the database files to be used (target organism databases and contaminant databases);
- Use the MS/MS data in the file to feed the #xtandem program that produces
      peptide identification results by matching the measured ion masses with
      peptide fragments calculated _in silico_ on the basis
      of the databases contents;
- Perform the protein inference step that leads to reliable protein
      identifications on the basis of the peptide identifications performed by
      #xtandem
- Display the data obtained at any step in powerful ways in a unified
      graphical user interface to allow the user to inspect the peptide
      identifications and also control the way these identifications are used to
      infer the protein identifications.
- Export the data after the results exploration above in a variety of
      formats.
- Perform quantitative proteomics on the basis of the results obtained at
      the previous steps.
- Perform bio-statistical analyses on the quantitative proteomics data
      obtained at the previous step.
      

== Feedback from the users

We are always grateful to any constructive feedback from the users.

The PAPPSO software team might be contacted _via_ the following contact page:

#linkext("http://pappso.inrae.fr/en/travailler_avec_nous/contact/", "http://pappso.inrae.fr/en/travailler_avec_nous/contact/") (search
  for team members having the #quote[Bioinformatics] specialty
  mentioned, like Olivier Langella or Filippo Rusconi).


  
== Program and Documentation Availability and License

The programs and all the documentation that are shipped along with the
  #i2mcq software suite are available at #linkext("http://pappso.inrae.fr/en/bioinfo/xtandempipeline/", "http://pappso.inrae.fr/en/bioinfo/xtandempipeline/"). Most of the
  time, a new version is published as source, and as binary install packages for
  #productname[MS-Windows] (64-bit systems only).

For #productname[GNU/Linux], binary packages are created
    locally (see #linkext("http://pappso.inrae.fr/en/bioinfo/xtandempipeline/download/", "http://pappso.inrae.fr/en/bioinfo/xtandempipeline/download/"))
    but are also built in the
    #productname[Debian]#footnote[#linkext("http://www.debian.org/", "http://www.debian.org/")] autobuilders and are
    uploaded to the distribution servers. These packages are available using the
    system's software management infrastructure (like using the
    #productname[Debian]'s #command[apt] command, for
    example, or the graphical application).


The software and all the documentation are all provided under the Free
Software license #emph[GNU General Public License, Version~3, or later,
at your option].  For an in-depth study of the #emph[Free
Software] philosphy, the reader is kindly urged to visit #linkext("http://www.gnu.org/philosophy", "http://www.gnu.org/philosophy").
