message("UNIX non APPLE environment")
message("Please run the configuration like this:")
message("cmake -G \"Unix Makefiles\" -DCMAKE_BUILD_TYPE=Debug ../development")
message("If building of the user manual is required, add -DBUILD_USER_MANUAL=1")
message("If using the locally built pappsomspp libs, add -DLOCAL_DEV=1")

# The TARGET changes according to the plaform
# For example, it changes to i2MassChroQ for macOS.
# Here we want it to be lowercase, UNIX-culture,
# and it is needed for the user manual build.
SET(TARGET i2masschroq)
SET(CAP_TARGET i2MassChroQ)

## Install directories
if(NOT CMAKE_INSTALL_PREFIX)
  set(CMAKE_INSTALL_PREFIX /usr)
endif()
set(BIN_DIR ${CMAKE_INSTALL_PREFIX}/bin)
set(DOC_DIR ${CMAKE_INSTALL_PREFIX}/share/doc/${TARGET})


# debian package : libboost-container-dev
find_package(
    Boost 1.88
    COMPONENTS chrono
               container
               filesystem
               iostreams
               thread
    REQUIRED
)

find_package( Qt6 COMPONENTS Core Gui Svg Xml PrintSupport Sql Network Concurrent Qml REQUIRED )


find_package(QCustomPlotQt6 REQUIRED)

find_package(SQLite3 REQUIRED)

find_package(PwizLite REQUIRED)

find_package(ZLIB REQUIRED)

find_package(liblzf REQUIRED)

find_package(QuaZip-Qt6 REQUIRED)

find_package(OdsStream COMPONENTS Core)

#sudo apt install cutelee6-qt6-dev
find_package(Cutelee6Qt6 REQUIRED)


set(PappsoMSpp_INCLUDE_DIR /home/langella/developpement/git/pappsomspp/src)
mark_as_advanced(PappsoMSpp_INCLUDE_DIR)
set(PappsoMSpp_INCLUDE_DIRS ${PappsoMSpp_INCLUDE_DIR})
# Look for the necessary library
set(PappsoMSpp_LIBRARY /home/langella/developpement/git/pappsomspp/build/src/pappsomspp/core/libpappsomspp-core.so)
mark_as_advanced(PappsoMSpp_LIBRARY)
# Mark the lib as found
set(PappsoMSpp_FOUND 1)
set(PappsoMSpp_LIBRARIES ${PappsoMSpp_LIBRARY})
if(NOT TARGET PappsoMSpp::Core)
    add_library(PappsoMSpp::Core UNKNOWN IMPORTED)
    set_target_properties(PappsoMSpp::Core PROPERTIES
        IMPORTED_LOCATION             "${PappsoMSpp_LIBRARY}"
        INTERFACE_INCLUDE_DIRECTORIES "${PappsoMSpp_INCLUDE_DIRS}")
endif()
set(PappsoMSppGui_LIBRARY /home/langella/developpement/git/pappsomspp/build/src/pappsomspp/gui/libpappsomspp-gui.so)
mark_as_advanced(PappsoMSppGui_LIBRARY)  
message(STATUS "~~~~~~~~~~~~~ ${PappsoMSppGui_LIBRARY} ~~~~~~~~~~~~~~~")
set(PappsoMSppGui_FOUND TRUE)
if(NOT TARGET PappsoMSpp::Gui)
    add_library(PappsoMSpp::Gui UNKNOWN IMPORTED)
    set_target_properties(PappsoMSpp::Gui PROPERTIES
        IMPORTED_LOCATION             "${PappsoMSppGui_LIBRARY}"
        INTERFACE_INCLUDE_DIRECTORIES "${PappsoMSpp_INCLUDE_DIRS}")
endif()


