
library("MCQR")
  message(paste("MCQRInfo: MCQR version :", packageVersion("MCQR")))
  library("xtable")
  library("svglite")
  library("readODS")
  library(data.table)

setwd("/gorgone/pappso/versions_logiciels_pappso/i2masschroq/1.0.21/mcqr_xic")

XICRAW <- mcq.read.masschroq(protFile = "/gorgone/pappso/versions_logiciels_pappso/masschroq/va2a4b31/eme/result_eme.d/all_msrun_proteins.tsv", pepFile = "/gorgone/pappso/versions_logiciels_pappso/masschroq/va2a4b31/eme/result_eme.d/peptides_q1_all_msrun.tsv")

summary (XICRAW)

META <- mcq.read.metadata("/gorgone/pappso/versions_logiciels_pappso/i2masschroq/1.0.21/mcqr_xic/metadata.ods")

XIC <- mcq.add.metadata(XICRAW, metadata=META)

  
XIC <- mcq.compute.normalization(XIC, method="median.RT")


get.proteobench <- function(pepq) {
  
  # sequence   ProForma  rawfile charge proteins
  #(containing "SPECIES" and separated with ";" if it is a protein group
  if ('ProForma' %in% names(pepq@proteins)) {
  }
  else {
    stop(paste("ProForma column is not present, please use at least MassChroQ version 2.4.5 to produce peptide quantification tables",sep=""))
  }
  data <- getdf(pepq)
  datamproteobench <-data[, c("sequence","ProForma", "z", "accession")]
  #datamsstats$sequence <- gsub("L","I",datamsstats$sequence)
  #datamsstats$sequence <- data$peptiniid
  colnames(datamproteobench) <- c("sequence","ProForma", "charge", "proteins")
  datamproteobench$charge <- data$z
  if ("label" %in% colnames(data)) {
    #datamproteobench$IsotopeLabelType <- data$label
    #datamproteobench$IsotopeLabelType <- str_replace(datamproteobench$IsotopeLabelType, "light", "L")
    #datamproteobench$IsotopeLabelType <- str_replace(datamproteobench$IsotopeLabelType, "heavy", "H")
    #datamproteobench$IsotopeLabelType[is.na(datamproteobench$IsotopeLabelType)] <- "L"
  }
  else {
    #datamproteobench$IsotopeLabelType <- "L"
  }
  
  datamproteobench$rawfile <- data$msrun
  if("areanorm" %in% colnames(data)){
    datamproteobench$area <- data$areanorm
  } else {
    datamproteobench$area <- data$area
  }
  #populate NA for missing values
  df_unique_ion <- unique(datamproteobench[c("sequence","ProForma", "charge", "proteins")])
  
  
  proteobench_conditions <- unique (datamproteobench[,c("rawfile", "proteins")])
  
  datamproteobench = as.data.table(datamproteobench)
  
  
  datamproteobench <- merge(cbind(pepq@metadata@injections, row=row.names(pepq@metadata@injections)), datamproteobench, by.x="row", by.y="rawfile")
  
  datamproteobench$row <- NULL;
  colnames(datamproteobench)[colnames(datamproteobench) == 'msrunfile'] <- 'rawfile'
  return (datamproteobench);
  
}


getdf <- function(object) {
  protein <- accession <- protein_description <- NULL
  temp_proteins = unique(object@proteins[,c("peptide", "protein", "accession", "protein_description")])
  
  shared.pep <- names(table(temp_proteins$peptide))[table(temp_proteins$peptide)>1]
  tab <- as.data.table(object@proteins[object@proteins$peptide %in% shared.pep,c("peptide", "protein", "accession", "protein_description")])
  tab <- tab[,list(protein = paste(protein, collapse=";"), accession = paste(accession, collapse=";"), protein_description = paste(protein_description, collapse=";")), by="peptide"]
  #tab <- ddply(tab, .(peptide), summarize,  protein=paste(protein, collapse=";"), accession=paste(accession, collapse=";"), protein_description=paste(protein_description, collapse=";"))
  tab <- rbind.data.frame(tab, object@proteins[!object@proteins$peptide %in% shared.pep,c("peptide", "protein", "accession", "protein_description")])
  
  indice <- match(object@peptides$peptide, tab$peptide)
  
  object@peptides$protein <- tab$protein[indice]
  object@peptides$accession <- tab$accession[indice]
  object@peptides$protein_description <- tab$protein_description[indice]
  if (nrow(object@metadata@metadata)!=0) {
    tpep <- merge(object@peptides, object@metadata@metadata, by.x="msrun", by.y="row.names")
  }
  
  tpep <- tpep[order(tpep$msrun,tpep$peptide),]
  colnames(tpep)[which(colnames(tpep)=="logarea")] <- "log10area"
  colnames(tpep)[which(colnames(tpep)=="lognorm")] <- "log10norm"
  
  
  if ('ProForma' %in% names(object@proteins)) {
    tpep <- merge(tpep, object@proteins[,c("peptide","ProForma")], by.x="peptide", by.y="peptide", all.x = TRUE)
  }
  return (unique(tpep))
}


df_proteobench <- get.proteobench(XIC)
write.table(df_proteobench, file = "proteobench_export.tsv", sep = "\t", row.names = F, quote = T)
