/**
 * \file /utils/httpversion.h
 * \date 2/11/2018
 * \author Olivier Langella
 * \brief check for new version on PAPPSO web site
 */

/*******************************************************************************
 * Copyright (c) 2018 Olivier Langella <olivier.langella@u-psud.fr>.
 *
 * This file is part of i2MassChroQ.
 *
 *     i2MassChroQ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     i2MassChroQ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with i2MassChroQ.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <olivier.langella@u-psud.fr> - initial API and
 *implementation
 ******************************************************************************/

#pragma once
#include <QNetworkAccessManager>
#include <QNetworkRequest>


class HttpVersion : public QObject
{
  Q_OBJECT

  public:
  HttpVersion();
  ~HttpVersion();
  bool isNewVersion() const;
  const QString &getVersion() const;
  const QString &getPermalink() const;


  public:
  signals:
  void httpVersionReady();

  private:
  QNetworkAccessManager *mpa_manager;
  QNetworkRequest m_request;
  QString m_onlineVersion;
  QString m_permalink;
};
