message("Create personal library directory and add it to the R library path");

dir.create(Sys.getenv("R_LIBS_USER"), recursive = TRUE)  # create personal library
.libPaths(Sys.getenv("R_LIBS_USER"))  # add to the path

message("Check package installation for TIDD");
# R base packages
all.packages = c('ROCR', 'e1071');
#bioc.packages = c('made4')


# install all packages
packages.to.install <- setdiff(all.packages, rownames(installed.packages()));
for (pkg in packages.to.install) {
  cat("Downloading and installing", pkg);
#  if (pkg %in% bioc.packages){
#    library(BiocManager)
#    BiocManager::install(pkg)
#  }else{
    install.packages(pkg, quiet = TRUE, repos = "http://cran.us.r-project.org");
#  }
}

# Check if all the mandatory packages are installed
if(length(setdiff(all.packages, rownames(installed.packages()))) == 0){
  message("All packages are installed");
}else{
    stop(paste("Some packages can't be installed :",
    cat(setdiff(all.packages, rownames(installed.packages())))));
}

