message("MCQRBegin: check_MSstats_install")
message("Check package installation for MSstats");

message("Create personal library directory and add it to the R library path");

dir.create(Sys.getenv("R_LIBS_USER"), recursive = TRUE)  # create personal library
.libPaths(Sys.getenv("R_LIBS_USER"))  # add to the path

# R base packages
all.packages = c('statmod')

# install all packages
packages.to.install <- setdiff(all.packages, rownames(installed.packages()))
for (pkg in packages.to.install) {
  cat("Downloading and installing", pkg)
  install.packages(pkg, quiet = TRUE, repos = "http://cran.us.r-project.org")
}


all.packages = c('MSstats')
packages.to.install <- setdiff(all.packages, rownames(installed.packages()));
for (pkg in packages.to.install) {
    if (!requireNamespace("BiocManager", quietly = TRUE))
        install.packages("BiocManager",quiet = TRUE, repos = "http://cran.us.r-project.org");
    BiocManager::install(version = "3.22", ask = FALSE)
    BiocManager::install("MSstats", ask = FALSE)
}


if(length(setdiff(all.packages, rownames(installed.packages()))) == 0){
    message("All packages are installed")
}else{
    message("Some packages can't be installed :")
    cat(setdiff(all.packages, rownames(installed.packages())))
}

message("MCQREnd: check_MSstats_install")
