
message("MCQRBegin: check_mcqr_package_install")

want.mcqr.version <- "1.0.2"
want.mcqr.url <- "https://forgemia.inra.fr/-/project/1534/uploads/6550076d01dab32a562598f355b17938/MCQR_1.0.2.tar.gz"

# deb: libudunits2-dev libgdal-dev (Debian, Ubuntu, ...)
# rpm: udunits2-devel (Fedora, EPEL, ...)
# brew: udunits (OSX)

message("Create personal library directory and add it to the R library path");

dir.create(Sys.getenv("R_LIBS_USER"), recursive = TRUE)  # create personal library
.libPaths(Sys.getenv("R_LIBS_USER"))  # add to the path


message("MCQRInfo: Check package installation")

if((version[['major']] < 4) || (strsplit(version[['minor']],"\\.")[[1]][1] < 2) ) {
    message("MCQRInfo: Error MCQR requires at least R version 4.2")
    stop(paste("Error : ","MCQR requires at least R version 4.2"))
}

# R base packages for MCQR
all.packages = c('Rcpp','utf8','fansi','pkgconfig','purrr', 'backports','R6', 'glue', 'magrittr','ellipsis', 'miniUI','digest', 'tibble', 'pillar', 'mime', 'promises', 'later', 'htmltools', 'miniUI', 'htmlwidgets','httr', 'stringr','stringi',  'jsonlite', 'zoo', 'mvtnorm','rstudioapi', 'highr','lazyeval', 'multcomp', 'bitops', 'caTools', 'gplots', 'gtools', 'gdata', 'chron', 'stringi', 'reshape2', 'data.table', 'readODS', 'vcd', 'lme4', 'car', 'carData', 'robustbase', 'colorspace', 'VIM', 'ade4', 'clValid', 'agricolae', 'ggplot2', 'gridExtra', 'Hmisc', 'RColorBrewer', 'plotly', 'plyr', 'dplyr', 'ggVennDiagram', 'svglite', 'tidyr','systemfonts', 'scales', 'tidyselect', 'zip')

#bioc.packages = c('made4')

is_installed <- function(pkg, ..., version = NULL, compare = NULL) {
  check_dots_empty0(...)

  info <- pkg_version_info(pkg, version = version, compare = compare)
  all(detect_installed(info))
}
packages_cpp <- c('cpp11')

#install all packages that are not already installed
install.packages(setdiff(packages_cpp, rownames(installed.packages())), quiet = TRUE, repos = "https://pbil.univ-lyon1.fr/CRAN/")

# install all packages
packages.to.install <- setdiff(all.packages, rownames(installed.packages()))
for (pkg in packages.to.install) {
  cat("MCQRInfo: Downloading and installing", pkg)
#  if (pkg %in% bioc.packages){
#    library(BiocManager)
#    BiocManager::install(pkg)
#  }else{
    install.packages(pkg, quiet = TRUE, repos = "https://pbil.univ-lyon1.fr/CRAN/")
#  }
}

# Check if all the mandatory packages are installed
if(length(setdiff(all.packages, rownames(installed.packages()))) == 0){
  message("All packages are installed")
}else{
  message("Some packages can't be installed :")
  cat(setdiff(all.packages, rownames(installed.packages())))
}

# Check if MCQR is installed
is.installed <- function(mypkg){
    is.element(mypkg, installed.packages()[,1])
} 

# check if package "hydroGOF" is installed
if (!is.installed("MCQR")){
    install.packages(want.mcqr.url, repo=NULL, type="source")
}
if(packageVersion("MCQR") == "0.6.11") {
    install.packages(want.mcqr.url, repo=NULL, type="source")
}
if(packageVersion("MCQR") < want.mcqr.version) {
    install.packages(want.mcqr.url, repo=NULL, type="source")
}

message("MCQREnd: check_mcqr_package_install")
