/**
 * \file /output/ods/xicareasheet.h
 * \date 16/10/2020
 * \author Thomas Renne
 * \brief ODS grouping sheet
 */

/*******************************************************************************
 * Copyright (c) 2020 Thomas Renne <thomas.renne@u-psud.fr>.
 *
 * This file is part of i2MassChroQ.
 *
 *     i2MassChroQ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     i2MassChroQ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with i2MassChroQ.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Thomas Renne <thomas.renne@u-psud.fr> - initial API and
 *implementation
 ******************************************************************************/
#pragma once

#include <odsstream/calcwriterinterface.h>
#include "../../core/project.h"
#include "../../gui/xic_view/xic_box/xicbox.h"

class XicAreaSheet
{
  public:
  XicAreaSheet(CalcWriterInterface *p_writer,
               QString project_name,
               const std::vector<XicBox *> xic_boxs,
               bool all_data = false);

  private:
  void writeAreaPeackdata(XicBox *xic_box);
  void writeXicAllData(XicBox *xic_box);
  void writeHeaders();
  void writeHeadersAllData();

  private:
  std::vector<XicBox *> mp_xicBoxList;
  CalcWriterInterface *mp_writer;
};
