/**
 * \file /output/ods/ptm/ptmgroupingsheet.cpp
 * \date 21/07/2025
 * \author Olivier Langella
 * \brief ODS PTM grouping sheet
 */

/*******************************************************************************
 * Copyright (c) 2025 Olivier Langella <olivier.langella@u-psud.fr>.
 *
 * This file is part of i2MassChroQ.
 *
 *     i2MassChroQ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     i2MassChroQ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with i2MassChroQ.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <olivier.langella@u-psud.fr> - initial API and
 *implementation
 ******************************************************************************/

#include "ptmgroupingsheet.h"
#include <pappsomspp/core/pappsoexception.h>


PtmGroupingSheet::PtmGroupingSheet(OdsExport *p_ods_export,
                                   CalcWriterInterface *p_writer,
                                   const Project *p_project)
  : mp_project(p_project)
{
  qDebug();
  mp_writer    = p_writer;
  mp_odsExport = p_ods_export;
  p_writer->writeSheet("PTM grouping");


  std::vector<IdentificationGroup *> identification_list =
    p_project->getIdentificationGroupList();
  for(IdentificationGroup *p_ident : identification_list)
    {
      // writeHeaders(p_ident);
      mp_ptmGroupingExperiment = p_ident->getPtmGroupingExperiment();
      if(mp_ptmGroupingExperiment == nullptr)
        {
          throw pappso::PappsoException(
            QObject::tr("Error writing PTM grouping :\nperhaps ptm grouping "
                        "was not done "));
        }

      mp_writer->writeLine();
      if(mp_project->getProjectMode() == ProjectMode::individual)
        {
          mp_writer->writeCell("sample");
        }
      mp_writer->setCellAnnotation("number of PTM island groups");
      mp_writer->writeCell("PTM island groups");
      mp_writer->setCellAnnotation("number of PTM island subgroups");
      mp_writer->writeCell("PTM island subgroups");
      mp_writer->setCellAnnotation("number of ptmislands");
      mp_writer->writeCell("PTM islands");


      mp_writer->writeLine();
      if(mp_project->getProjectMode() == ProjectMode::individual)
        {
          mp_writer->writeCell(
            p_ident->getMsRunSpList().at(0).get()->getSampleName());
        }
      mp_writer->writeCell(
        mp_ptmGroupingExperiment->getPtmIslandGroupList().size());
      mp_writer->writeCell(
        mp_ptmGroupingExperiment->getPtmIslandSubgroupList().size());
      mp_writer->writeCell(mp_ptmGroupingExperiment->getPtmIslandList().size());
      // ui->ptm_island_tableview->resizeRowToContents(_ptm_table_model_p->rowCount());
    }
}


PtmGroupingSheet::~PtmGroupingSheet()
{
}
