/**
 * \file input/psmcbor/cborpsmfilereader.h
 * \date 14/11/2024
 * \author Olivier Langella
 * \brief read data files from CBOR PSM
 */

/*******************************************************************************
 * Copyright (c) 2025 Olivier Langella
 *<Olivier.Langella@universite-paris-saclay.fr>.
 *
 * This file is part of i2MassChroQ.
 *
 *     i2MassChroQ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     i2MassChroQ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with i2MassChroQ.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/


#pragma once
#include "../../core/project.h"
#include "../../core/identification_sources/identificationdatasource.h"
#include "../../utils/workmonitor.h"
#include <pappsomspp/core/processing/cbor/psm/psmfilereaderbase.h>
/**
 * @todo write docs
 */
class CborPsmFileReader : public pappso::cbor::psm::PsmFileReaderBase
{
  public:
  /**
   * Default constructor
   */
  CborPsmFileReader(Project *p_project);

  /**
   * Destructor
   */
  virtual ~CborPsmFileReader() override;


  protected:
  virtual void informationsReady(pappso::UiMonitorInterface &monitor) override;

  virtual void parameterMapReady(pappso::UiMonitorInterface &monitor) override;


  virtual void sampleStarted(pappso::UiMonitorInterface &monitor) override;

  virtual void proteinMapReady(pappso::UiMonitorInterface &monitor) override;
  virtual void psmReady(pappso::UiMonitorInterface &monitor) override;

  virtual void fastaFilesReady(pappso::UiMonitorInterface &monitor) override;

  virtual void sampleListFinished(pappso::UiMonitorInterface &monitor) override;

  private:
  void storeSageEval(PeptideEvidence &pe, const QCborMap &sage_cbor_map);
  void fillPeptideEvidence(PeptideEvidence &pe);


  void assignProteinXtpToFastaFiles();

  private:
  Project *mp_project = nullptr;
  MsRunSp msp_currentMsrun;
  std::vector<IdentificationEngine> m_identificationEngineList;
  std::map<IdentificationEngine, QJsonDocument>
    m_identificationEngineParameterMap;
  std::map<IdentificationEngine, IdentificationDataSourceSp>
    m_currentIdentificationEngineToIdentificationDataSourceSpMap;
  std::size_t m_indexIdentificationSource = 0;

  std::map<QString, ProteinXtpSp> m_proteinXtpSpMap;
  IdentificationGroup *mp_currentIdentificationGroup = nullptr;

  std::vector<FastaFileSp> m_allFastaFileSp;
};
