/**
 * \file /input/datafilenotsupportedexception.h
 * \date 29/5/2020
 * \author Olivier Langella
 * \brief Exception launched if format is not supported
 */

/*******************************************************************************
 * Copyright (c) 2020 Olivier Langella <olivier.langella@u-psud.fr>.
 *
 * This file is part of i2MassChroQ.
 *
 *     i2MassChroQ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     i2MassChroQ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with i2MassChroQ.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/

#pragma once


#include <pappsomspp/core/pappsoexception.h>

class DataFileNotSupportedException : public pappso::PappsoException
{
  public:
  DataFileNotSupportedException(const QString &message) throw()
    : pappso::PappsoException(message)
  {
  }


  virtual QException *
  clone() const override
  {
    return new DataFileNotSupportedException(*this);
  }
};
