
/*******************************************************************************
 * Copyright (c) 2017 Olivier Langella <olivier.langella@u-psud.fr>.
 *
 * This file is part of i2MassChroQ.
 *
 *     i2MassChroQ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     i2MassChroQ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with i2MassChroQ.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <olivier.langella@u-psud.fr> - initial API and
 *implementation
 ******************************************************************************/

#pragma once

#include "../projectwindow.h"

namespace Ui
{
class IdentificationGroupWidget;
}


class IdentificationGroupWidget : public QWidget
{
  Q_OBJECT

  public:
  explicit IdentificationGroupWidget(QWidget *parent);
  ~IdentificationGroupWidget();

  public:
  void setIdentificationGroup(ProjectWindow *parent,
                              IdentificationGroup *p_identification_group);

  public slots:
  void doViewProteinList();
  void doViewPtmIslandList();
  void doViewMsIdentificationList();
  void
  doIdentificationGroupGrouped(IdentificationGroup *p_identification_group);


  private:
  Ui::IdentificationGroupWidget *ui;
  ProjectWindow *_p_project_window;
  IdentificationGroup *_p_identification_group;
};

Q_DECLARE_METATYPE(IdentificationGroupWidget *)
