/**
 * \file core/sage_run/sageslurmprocess.cpp
 * \date 11/05/2025
 * \author Olivier Langella
 * \brief handles execution of a Sage process through Slurm
 */

/*******************************************************************************
 * Copyright (c) 2025 Olivier Langella
 *<Olivier.Langella@universite-paris-saclay.fr>.
 *
 * This file is part of i2MassChroQ.
 *
 *     i2MassChroQ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     i2MassChroQ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with i2MassChroQ.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/

#include "sageslurmprocess.h"

SageSlurmProcess::SageSlurmProcess(MainWindow *p_main_window,
                                   WorkMonitorInterface *p_monitor,
                                   const SageRunBatch &sage_run_batch)
  : SageBatchProcess(p_main_window, p_monitor, sage_run_batch)
{
  m_isSlurm = true;
}

SageSlurmProcess::~SageSlurmProcess()
{
}
