/**
 * \file core/sage_run/sagebatchprocess.h
 * \date 11/05/2025
 * \author Olivier Langella
 * \brief handles execution of a Sage process
 */

/*******************************************************************************
 * Copyright (c) 2025 Olivier Langella
 *<Olivier.Langella@universite-paris-saclay.fr>.
 *
 * This file is part of i2MassChroQ.
 *
 *     i2MassChroQ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     i2MassChroQ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with i2MassChroQ.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/

#pragma once


#include "sagerunbatch.h"
#include "../../gui/mainwindow.h"
#include "../../utils/workmonitor.h"

/**
 * @todo write docs
 */
class SageBatchProcess : public QObject
{
  Q_OBJECT
  public:
  /**
   * Default constructor
   */
  SageBatchProcess(MainWindow *p_main_window,
                   WorkMonitorInterface *p_monitor,
                   const SageRunBatch sage_param);

  /**
   * Destructor
   */
  virtual ~SageBatchProcess();
  virtual void run();

  protected:
  void prepareTemporaryDirectory();

  protected:
  SageRunBatch m_sageRunBatch;
  WorkMonitorInterface *mp_monitor;
  QString m_sageErrorString;

  QProcess *mpa_sageProcess = nullptr;
  QTemporaryDir *mp_tmpDir  = nullptr;
  bool m_isSlurm            = false;


  protected slots:
  void readyReadStandardOutput();
  void readyReadStandardError();


  private:
  MainWindow *mp_mainWindow = nullptr;
};
