/**
 * \file src/cli/export/cborstreamreaderalignment.h
 * \date 18/07/2025
 * \author Olivier Langella
 * \brief read cbor stream to export alignment data
 */

/*******************************************************************************
 * Copyright (c) 2025 Olivier Langella
 *<Olivier.Langella@universite-paris-saclay.fr>.
 *
 * This file is part of MassChroQ.
 *
 *     MassChroQ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     MassChroQ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with MassChroQ.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/

#pragma once

#include <odsstream/tsvoutputstream.h>
#include "cborstreamreaderbase.h"
/**
 * @todo write docs
 */
class CborStreamReaderAlignment : public CborStreamReaderBase
{
  public:
  /**
   * Default constructor
   */
  CborStreamReaderAlignment(const QString &output_directory);

  /**
   * Destructor
   */
  ~CborStreamReaderAlignment();

  protected:
  void readAlignmentData(pappso::UiMonitorInterface &monitor) override;
  void readQuantificationData(pappso::UiMonitorInterface &monitor) override;

  private:
  void writeOneAlignment(const QString &msrun_id, QCborMap cbor_corrections);


  private:
  TsvDirectoryWriter *mpa_calcWriterInterface;
  QString m_groupId;
};
