#import "../template.typ": *

#show: doc => conf(
  authors: (
    (
      name: "Benoît Valot",
    ),
    (
      name: "Olivier Langella",
    ),
    (
      name: "Edlira Nano",
    ),
    (
      name: "Filippo Rusconi",
    ),
  ),
  toc: true,
  lang: "en",
  font: "EB Garamond 12",
  date: "14/02/2025",
  years: (2025),
  version: json("../user-manual-version.json").masschroq_version,
  subtitle: "Free and Open Source Peptide Quantification Software",
  "MassChroQ3 User Manual",
  doc
)

= #mcq3

= #mcq export tool

#mcq3 comes with a CLI tool #emph[masschroq-export] to extract data from the CBOR #mcq3 output file

#code-prompt("masschroq-export -h",  title: "masschroq-export online help")


== Export alignment data to JSON<mcq-export-json>

#code-prompt("masschroq-export --json alignment_data.json mcq_quantification_results.cbor",  title: "extracting alignment data to JSON file")

== Generate PDF alignment data report using Typst

You need the JSON alignment data file generated in @mcq-export-json.
Prepare a simple Typst file (text file with .typ extension) called "alignment.typ" with this content:

#let code_typst = read("example_alignment.typ")
#code-block(title: "", code_typst.replace("_proteograph_version_",json("../user-manual-version.json").proteograph_version), "typst")

And compile this file using :
#code-prompt("typst compile alignment.typ",  title: "Compile alignment typst file")




== Export quantification data to JSON<mcq-export-peptide-json>

#code-prompt("masschroq-export --peptide pepa1b12 --json quantification.json mcq_quantification_results.cbor",  title: "extracting quantification data of pepa1b12 to JSON file")

== Generate PDF quantification report using Typst

You need the JSON alignment data file generated in @mcq-export-peptide-json.
Prepare a simple Typst file (text file with .typ extension) called "quantification.typ" with this content:

#let code_typst = read("example_peptide_quantification.typ")
#code-block(title: "", code_typst.replace("_proteograph_version_",json("../user-manual-version.json").proteograph_version), "typst")

And compile this file using :
#code-prompt("typst compile quantification.typ",  title: "Compile peptide quantification typst file")


= Peak quality code

/ aa: best quality : many MS2 fragmentation event, only one peak directly detected
/ zaa: same as aa, but this charge state was not directly observed in MS2 fragmentation events in this MSrun
/ a: good quality, single MS2 fragmentation event, one peak detected
/ za: same as a, but this charge state was not directly observed in MS2 fragmentation events in this MSrun
/ ab: many MS2 fragmentation event, but more than one peak detected, the greater peak (area) is chosen, it is obviously fragmented... perhaps a hint to check for peak detection parameters
/ zab: same as ab, but this charge state was not directly observed in MS2 fragmentation events in this MSrun
/ b: peak obtained by "match between run" on the mean aligned observed retention times in MS2 fragmentation events *and* also matching with the retention time given by other detected and quantifified MS1 apex peaks in other MS runs
/ c: peak obtained by "match between run" only on the mean of aligned observed retention times in MS2 fragmentation events
/ d: peak obtained by "match between run" only matching with the retention time given by other detected and quantifified MS1 apex peaks in other MS runs

/ missed: no peak detected, no quantification 



#bibliography(style:"frontiers", "../biblio.bib")
