#!/usr/bin/python3
"""
class for management of report.log file from diann.
the function parse the files and store mandatory information for the functions
"""

# base import
import re
import os

# personnal class import
from utils.UNIMOD import UNIMOD
from diannReader.configDiann import configDiann


class reportLog():

    # init function
    # args the filename with fullpath of the log file
    def __init__(self, filename):
        if os.path.isfile(filename):
            self.filename = filename
        else:
            raise OSError(f"{filename} does not exist or is not readable.\n\
                          Please Verify the file exist and is readable.")

    # small function to translate unimod string define directly in diann
    # command line
    def _translateToUnimodProforma(self, unimodString):
        unimod = unimodString.replace("u", "U")
        unimod = unimod.replace("m", "M")
        unimod = unimod[0:6]+":"+unimod[6:]
        result = {"unimod": "",
                  "mass_modification": "",
                  "amino_acid": "", "modType": ""}
        if unimod[7:] == "4":
            result = {"unimod": unimod,
                      "mass_modification": UNIMOD[unimod]["mass_modification"],
                      "amino_acid": "C", "modType": "fixed"}
        return result

    def _parseVersionLine(self, version):
        self.version = {}
        names = ["MAJOR", "MINOR", "PATCH"]
        version = version.split(".")
        self.version = dict(zip(names, version))

# fonction trop complexe a factoriser sortir le cas cfg pour le traiter ailleur
    def _parseCommandLine(self, line):
        # defining regex
        pattern = dict()
        pattern["inputfile"] = re.compile(r"--f (\S+\.mzML|\S+\.mzXML|\S+\.d)")
        pattern["fastafile"] = re.compile(r"--fasta (\S+)")
        pattern["mods"] = re.compile(r"--var-mod (\S+)")
        pattern["unimod"] = re.compile(r"--(unimod\d+)")
        pattern["QValue"] = re.compile(r"--qvalue (\S+)")
        pattern["matrix_Qvalue"] = re.compile(r"--matrix-qvalue (\S+)")
        pattern["cfg"] = re.compile(r"--cfg (\S+\.cfg)")
        # defining result variable
        self.fastafile = []
        self.inputfile = []
        self.mods = {}
        self.no_inf = False
        self.QValue = -1
        self.matrix_Qvalue = -1
        self.reportDecoy = False
        # retrieving informations form line via regex
        for m in re.finditer(pattern["inputfile"], line):
            self.inputfile.append(m.group(1))
        for m in re.finditer(pattern["fastafile"], line):
            self.fastafile.append(m.group(1))
        for m in re.finditer(pattern["mods"], line):
            tabmod = m.group(1).split(",")
            mod = {"unimod": tabmod[0], "mass_modification": tabmod[1],
                   "amino_acid": tabmod[2], "modType": "variable"}
            self.mods[tabmod[0]] = mod
        for m in re.finditer(r"--(unimod\d+)", line):
            print(m.group(1))
            unimod = self._translateToUnimodProforma(m.group(1))
            self.mods[unimod["unimod"]] = unimod
        for m in re.finditer(r"--qvalue (\S+)", line):
            self.QValue = float(m.group(1))
        for m in re.finditer(r"--matrix-qvalue (\S+)", line):
            self.matrix_Qvalue = float(m.group(1))
        # retrieve information from line by chekc the presence of arguments
        for m in re.finditer(pattern["cfg"], line):
            self.myconfig = configDiann()
            self.myconfig.readCfg(m.group(1))
            self.inputfile = self.myconfig.getRawFileList()
            self.fastafile = self.myconfig.getFastaFileList()
            if self.myconfig.hasParam("var-mod"):
                for tabmod in self.myconfig.getParamWithArg("var-mod"):
                    tabmod = tabmod.split(",")
                    mod = {"unimod": tabmod[0], "mass_modification": tabmod[1],
                           "amino_acid": tabmod[2], "modType": "variable"}
                    self.mods[tabmod[0]] = mod
            if self.myconfig.hasParam("fixed-mod"):
                for tabmod in self.myconfig.getParamWithArg("fixed-mod"):
                    tabmod = tabmod.split(",")
                    mod = {"unimod": tabmod[0], "mass_modification": tabmod[1],
                           "amino_acid": tabmod[2], "modType": "variable"}
                    self.mods[tabmod[0]] = mod
            if self.myconfig.hasParam("mod"):
                for tabmod in self.myconfig.getParamWithArg("mod"):
                    tabmod = tabmod.split(",")
                    mod = {"unimod": tabmod[0], "mass_modification": tabmod[1],
                           "amino_acid": tabmod[2], "modType": "variable"}
                    self.mods[tabmod[0]] = mod
            if self.myconfig.hasParam("no-prot-inf"):
                self.no_inf = True
            if self.myconfig.hasParam("report-decoys"):
                self.reportDecoy = True
            if self.myconfig.hasParam("qvalue"):
                self.QValue = float(self.myconfig.getParamWithArg("qvalue")[0])
            if self.myconfig.hasParam("matrix-qvalue"):
                self.matrix_Qvalue = float(self.myconfig.getParamWithArg(
                    "matrix-qvalue")[0])
            if self.myconfig.hasUnimod():
                for unimod in self.myconfig.getUnimods():
                    self.mods[unimod] = self._translateToUnimodProforma(unimod)
        if "--no-prot-inf" in line:
            self.no_inf = True
        if "--report-decoys" in line:
            self.reportDecoy = True

    def parselog(self):
        logfile = open(self.filename, 'r')
        for line in logfile:
            diannVersion = re.search(r"DIA-NN (\S+) .*\(Data-Independent Acquisition by Neural Networks\)", line)  # noqa: E501
            if diannVersion is not None:
                self._parseVersionLine(diannVersion.group(1))
            if "--fasta" in line or "--cfg" in line:
                self._parseCommandLine(line)

    # getters
    def getInputFile(self):
        return self.inputfile

    def getFastaFile(self):
        return self.fastafile

    def getMods(self):
        return self.mods

    def getQValue(self):
        return self.QValue

    def getMatriceQValue(self):
        return self.matrix_Qvalue

    def isInfered(self):
        return not self.no_inf

    def isDecoyReported(self):
        return self.reportDecoy

    def getVersion(self):
        return self.version

