

#let conf(
  subtitle: none,
  authors: (),
  toc: true,
  lang: "en",
  font: "Satoshi",
  date: none,
  years: (2024, 2025),
  version: none,
  title,
  doc,
) = {

  set text(lang: lang, font: font, fallback: false)
  v(32pt)
  v(32pt)
  let count = authors.len()
  let ncols = 1
  if count > 3 {
      ncols = 2
  }
  v(32pt)

  align(center)[
    #line(length: 100%)
    #v(16pt)
    #text(32pt, title, weight: "semibold")\
    #v(16pt)
    #if (subtitle != none) {
      line(length: 10%)
      text(24pt, subtitle, weight: "medium")
    }
    #line(length: 100%)
    #v(64pt)
    #text(20pt, str("version: ") + version)

    #align(bottom)[
      #grid(
        columns: (0.5fr,) * ncols,
        row-gutter: 12pt,
        ..authors.map(author => [
          #text(16pt, author.name) \
        ]
        ),
      )]
  ]

  pagebreak()
  set align(left)
  show heading.where(level: 1):  it => [
    #pad(
      top: 6pt,
      text(22pt ,it.body)
    )
  ]

  show outline.entry.where(
    level: 1
  ): it => {
    v(12pt, weak: true)
    strong(it)
  }

  if toc {
    outline(indent: 2em, depth: 1)
    pagebreak()
  }
  set page(
    margin: (top: 42pt),
    header: [
      #set text(8pt)
      #smallcaps[#title]
      #if (date != none) {
        h(1fr) + text(date)
      }
      #line(length: 100%)
    ],
  )
  doc
}

#let c = counter("question")
#let question(title, counter: true) = context {
  v(8pt)
  if (counter) {
    c.step()
    heading(level: 2, c.display() + ") " + title)
  } else {
    heading(level: 2, title)
  }  
  v(4pt)
}

#let code-block(code, language, title: none) = {
  v(6pt)

  if (title != none) {
    text(10pt, style: "italic", title) 
    linebreak()
  }
  raw(code, lang: language)
  v(6pt)
}

#let remarque(qui: none, content, bg-color: teal.lighten(60%)) = {
  v(4pt)
  block(
    fill: bg-color,
    width: 100%,
    inset: 8pt,
    radius: 4pt,
    text(10pt, terms((qui, content)))
  )
}


