import sys
import logging
# sys.path.append('/home/tballiau/groupingprotein/src/python/')
sys.path.append('/home/tballiau/dia_scripts/Script_Python/src/')  # noqa: E402

from pstruct.configDiann import configDiann
# https:/stackoverflow.com/questions/16571150/how-to-capture-stdout-output-from-a-python-function-call
from io import StringIO

logging.basicConfig()

# By default the root logger is set to WARNING and all loggers you define
# inherit that value. Here we set the root logger to NOTSET. This logging
# level is automatically inherited by all existing and new sub-loggers
# that do not set a less verbose level.
logging.root.setLevel(logging.NOTSET)

# The following line sets the root logger level as well.
# It's equivalent to both previous statements combined:
logging.basicConfig(level=logging.NOTSET)


# You can either share the `logger` object between all your files or the
# name handle (here `my-app`) and call `logging.getLogger` with it.
# The result is the same.
handle = "my-app"

logger = logging.getLogger(__name__)
FORMAT = "[%(filename)s:%(lineno)s - %(funcName)20s() ] %(message)s"
logging.basicConfig(format=FORMAT)
logger.setLevel(logging.INFO)
# Convenient methods in order of verbosity from highest to lowest
logger.debug("this will get printed")
logger.info("this will get printed")
logger.warning("this will get printed")
logger.error("this will get printed")
logger.critical("this will get printed")

class Capturing(list):
    def __enter__(self):
        self._stdout = sys.stdout
        sys.stdout = self._stringio = StringIO()
        return self

    def __exit__(self, *args):
        self.extend(self._stringio.getvalue().splitlines())
        del self._stringio    # free up some memory
        sys.stdout = self._stdout


diann_file = "/home/tballiau/dia_scripts/Script_Python/diann_run.cfg"

configdiann = configDiann()

configdiann.readCfg(diann_file)

# logging.info config file path
logging.info(configdiann.getOriginalFile())

# logging.info param without arg
logging.info(configdiann.getParam())

# logging.info param with arg
logging.info(configdiann.getParamWithArg())

# check rawfile import
rawfileList = ['/gorgone/pappso/moulon/raw/20250725_arthur_27/7-25-2025_20250725_arthur_27_bulk_01_13119.d',
  '/gorgone/pappso/moulon/raw/20250725_arthur_27/7-26-2025_20250725_arthur_27_A2_13132.d',
  '/gorgone/pappso/moulon/raw/20250725_arthur_27/7-26-2025_20250725_arthur_27_A3_13138.d',
  '/gorgone/pappso/moulon/raw/20250725_arthur_27/7-26-2025_20250725_arthur_27_B1_13124.d',
  '/gorgone/pappso/moulon/raw/20250725_arthur_27/7-26-2025_20250725_arthur_27_B2_13130.d',
  '/gorgone/pappso/moulon/raw/20250725_arthur_27/7-26-2025_20250725_arthur_27_B3_13136.d',
  '/gorgone/pappso/moulon/raw/20250725_arthur_27/7-26-2025_20250725_arthur_27_bulk_02_13133.d',
  '/gorgone/pappso/moulon/raw/20250725_arthur_27/7-26-2025_20250725_arthur_27_C1_13126.d',
  '/gorgone/pappso/moulon/raw/20250725_arthur_27/7-26-2025_20250725_arthur_27_C2_13128.d',
  '/gorgone/pappso/moulon/raw/20250725_arthur_27/7-27-2025_20250725_arthur_27_A4_13146.d',
  '/gorgone/pappso/moulon/raw/20250725_arthur_27/7-27-2025_20250725_arthur_27_A5_13148.d',
  '/gorgone/pappso/moulon/raw/20250725_arthur_27/7-27-2025_20250725_arthur_27_B4_13142.d',
  '/gorgone/pappso/moulon/raw/20250725_arthur_27/7-27-2025_20250725_arthur_27_B5_13152.d',
  '/gorgone/pappso/moulon/raw/20250725_arthur_27/7-27-2025_20250725_arthur_27_bulk_03_13153.d',
  '/gorgone/pappso/moulon/raw/20250725_arthur_27/7-27-2025_20250725_arthur_27_C3_13140.d',
  '/gorgone/pappso/moulon/raw/20250725_arthur_27/7-27-2025_20250725_arthur_27_C4_13144.d',
  '/gorgone/pappso/moulon/raw/20250725_arthur_27/7-27-2025_20250725_arthur_27_C5_13150.d',
  '/gorgone/pappso/moulon/raw/20250725_arthur_27/7-28-2025_20250725_arthur_27_A6_13158.d',
  '/gorgone/pappso/moulon/raw/20250725_arthur_27/7-28-2025_20250725_arthur_27_A7_13162.d',
  '/gorgone/pappso/moulon/raw/20250725_arthur_27/7-28-2025_20250725_arthur_27_B6_13160.d',
  '/gorgone/pappso/moulon/raw/20250725_arthur_27/7-28-2025_20250725_arthur_27_B7_13164.d',
  '/gorgone/pappso/moulon/raw/20250725_arthur_27/7-28-2025_20250725_arthur_27_bulk_04_13167.d',
  '/gorgone/pappso/moulon/raw/20250725_arthur_27/7-28-2025_20250725_arthur_27_C6_13156.d',
  '/gorgone/pappso/moulon/raw/20250725_arthur_27/7-28-2025_20250725_arthur_27_C7_13166.d' ,]

logging.info(f"importing {len(rawfileList)} files in object.")

configdiann.addSamples(rawfileList)

settedrawfile = configdiann.getRawFileList()
unfoundFile = []
for file in rawfileList:
    if file not in settedrawfile:
        unfoundFile.append(file)
logging.info(f"number of file not found in object: {len(unfoundFile)}")
if len(unfoundFile) != 0:
    logging.info(unfoundFile)

logging.info("check for duplication import")
badImport = ['/gorgone/pappso/moulon/raw/20250725_arthur_27/7-28-2025_20250725_arthur_27_B7_13164.d',
  '/gorgone/pappso/moulon/raw/20250725_arthur_27/7-28-2025_20250725_arthur_27_bulk_04_13167.d',
  '/gorgone/pappso/moulon/raw/20250725_arthur_27/7-28-2025_20250725_arthur_27_C6_13156.d',
  '/gorgone/pappso/moulon/raw/20250725_arthur_27/7-28-2025_20250725_arthur_27_C7_13166.d' ,]


with Capturing() as output:
    configdiann.addSamples(badImport)
nb_not_imported = 0
for sample in badImport:
    for line in output:
        if sample in line:
            logging.info(f"{sample} was not imported")
            nb_not_imported += 1
if nb_not_imported == len(badImport):
    logging.info("All duplicated samples were skipped : OK")
else:
    logging.info("Some duplicated samples were imported : need check")

## check fastafile import

fastafiles = ['/gorgone/pappso/moulon/database/Integr8_E_coli_K12_20081030.fasta',
              '/gorgone/pappso/moulon/database/contaminants_standarts.fasta']


logging.info("check for fastafile import")

logging.info(f"importing {len(fastafiles)} files in object.")

configdiann.addFastaFile(fastafiles)

settedfastafiles = configdiann.getFastaFileList()
unfoundFile = []
for file in fastafiles:
    if file not in settedfastafiles:
        unfoundFile.append(file)
logging.info(f"number of fasta not found in object: {len(unfoundFile)}")
if len(unfoundFile) != 0:
    logging.info(unfoundFile)

logging.info("check for duplication import")
badImport = ['/gorgone/pappso/moulon/database/contaminants_standarts.fasta']

with Capturing() as output:
    configdiann.addFastaFile(fastafiles)
nb_not_imported = 0
for fasta in badImport:
    for line in output:
        if fasta in line:
            logging.info(f"{fasta} was not imported")
            nb_not_imported += 1
if nb_not_imported == len(badImport):
    logging.info("All duplicated fasta were skipped : OK")
else:
    logging.info("Some duplicated fasta were imported : need check")

# export to json
jsonstring = configdiann.toJSON()
logging.info(jsonstring)

# test import from json to new object
newConfigDiann = configDiann()
newConfigDiann.fromJSON(jsonstring)

logging.info(configdiann.toCfg())



