from PyQt5.QtCore import pyqtSignal, QSettings
from PyQt5.QtGui import QIcon
from PyQt5.QtWidgets import QWidget, QErrorMessage, QAbstractItemView
from PyQt5.QtWidgets import QListWidgetItem, QInputDialog
from math import floor
from os import listdir, path
import logging
from importlib import resources as impresources
from ressource import images

from pwidget.ui_pfileDialog import ui_pfileDialog
# from server.sftp_server import sftp_server


logging.basicConfig()
logging.root.setLevel(logging.NOTSET)
logging.basicConfig(level=logging.NOTSET)

logger = logging.getLogger(__name__)
FORMAT = "[%(filename)s:%(lineno)s - %(funcName)20s() ] %(message)s"
logging.basicConfig(format=FORMAT)
logger.setLevel(logging.INFO)


class pfileDialog(QWidget):
    selectDirectoryEvent = pyqtSignal(list)

# currentDirectory must be full path directory
# multiple is a boolean specify if selection is mulktiple or not
# select_only activate or not the possibility to create directory

    def __init__(self, currentDirectory, multiple, select_only):
        QWidget.__init__(self)
        self.ui = ui_pfileDialog()
        self.ui.setupUi(self)
        if multiple:
            self.ui.listWidget.setSelectionMode(
                QAbstractItemView.ExtendedSelection)
        self.ui.validateDirectoryButton.clicked.connect(
                self.selectDirectory)
        self.currentDirectory = currentDirectory
        self.populateDirectoryList(currentDirectory)

# retrieve the list of file and directory for a given directory
    def populateDirectoryList(self, directory):
        try:
            logging.info(directory)
            logging.info(path.isdir(directory))
            if path.isdir(directory):
                self.ui.listWidget.clear()
                directories = listdir(directory)
                directories.sort()
                for itemdirectory in directories:
                    if self.currentDirectory.endswith("/"):
                        test = self.currentDirectory + itemdirectory
                    else:
                        test = self.currentDirectory + "/" + itemdirectory
                    if path.isdir(test):
                        dirpng = impresources.files(images) / 'dir.png'
                        icon = QIcon(str(dirpng))
                        self.ui.listWidget.addItem(
                            QListWidgetItem(icon, itemdirectory))
                    else:
                        filepng = impresources.files(images) / 'file.png'
                        icon = QIcon(str(filepng))
                        self.ui.listWidget.addItem(
                            QListWidgetItem(icon, itemdirectory))
                self.ui.listWidget.addItem("..")
            else:
                logging.info("nothing to do selected item is a file")
                self.currentDirectory = self.currentDirectory[
                    0:self.currentDirectory.rindex("/")]
        except PermissionError:
            error = QErrorMessage(self)
            error.showMessage(f"{directory} directory is not readable")

    def createDirectory(self):
        logging.info("create directory")
        directoryname, ok = QInputDialog.getText(self,
                                                 'create Directory',
                                                 'Enter your direcotry name')
        if ok:
            self.server.mkdir(directoryname)
        self.populateDirectoryList(self.currentDirectory)

    # def selectDirectory(self):
    #     logging.info("select directory")
    #     ## test if there is a selected row and use it. if not use the currentdirector
    #     if self.ui.listWidget.item(self.ui.listWidget.currentRow()) is None:
    #         test = self.currentDirectory
    #     else:
    #         directory = self.ui.listWidget.item(self.ui.listWidget.currentRow()).text()
    #         if self.currentDirectory.endswith("/"):
    #             test = self.currentDirectory + directory
    #         else:
    #             test = self.currentDirectory + "/" + directory
    #     logging.info(test)
    #     settings = QSettings("PAPPSO", "pyRawConverter")
    #     settings.beginGroup("parameter")
    #     settings.setValue(self.setting, test[0:test[0:-1].rindex("/")])
    #     result = [test, self.server.isdir(test)]
    #     self.selectDirectoryEvent.emit(result)

    def selectDirectory(self):
        logging.info("select item")
        # test if there is a selected row and use it. if not use the currentdirector
        result = []
        items = self.ui.listWidget.selectedItems()
        for currentitem in items:
            currentitem = currentitem.text()
            if self.currentDirectory.endswith("/"):
                itemfull = self.currentDirectory + currentitem
            else:
                itemfull = self.currentDirectory + "/" + currentitem
            result.append([currentitem, path.isdir(itemfull)])
            logging.info(currentitem)
        logging.info(result)
        # settings = QSettings("PAPPSO", "pyRawConverter")
        # settings.beginGroup("parameter")
        # settings.setValue(self.setting, item[0:item[0:-1].rindex("/")])
        self.selectDirectoryEvent.emit(result)
        self.hide()

    def cancel(self):
        logging.info("cancel")
        self.hide()

    def validateDirectory(self):
        logging.info("validate directory")
        try:
            directory = self.ui.currentDirectory.text()
            self.currentDirectory = directory
            logging.info(directory)
            self.populateDirectoryList(self.currentDirectory)
        except:
            logging.info("something to do")

    def modifyDirectory(self, itemDoubleClicked):
        logging.info(self.currentDirectory)
        logging.info(itemDoubleClicked.text())
        if itemDoubleClicked.text() == "..":
            if self.currentDirectory == "/":
                logging.info("nothing to do")
            else:
                self.currentDirectory = self.currentDirectory[:self.currentDirectory.rindex("/")]
                logging.info(self.currentDirectory)
                if self.currentDirectory == "":
                    self.currentDirectory = "/"
                    self.populateDirectoryList(self.currentDirectory)
                else:
                    self.populateDirectoryList(self.currentDirectory)
        else:
            self.currentDirectory = path.join(self.currentDirectory,
                                              itemDoubleClicked.text())
            # if self.currentDirectory.endswith("/"):
            #     self.currentDirectory = self.currentDirectory + itemDoubleClicked.text()
            # else:
            #     self.currentDirectory = self.currentDirectory + "/" + itemDoubleClicked.text()
            self.ui.currentDirectory.setText(self.currentDirectory)
            self.populateDirectoryList(self.currentDirectory)

    def getCurrentDirectory(self):
        return self.currentDirectory
