import logging
from importlib import resources as impresources
from os.path import dirname as Pathdirname
from os.path import isfile as Pathisfile
from os.path import join as PathJoin
from typing import override

from PyQt5.QtCore import QEvent, pyqtSignal
from PyQt5.QtGui import QResizeEvent
from PyQt5.QtWidgets import (
    QFileDialog,
    QInputDialog,
    QLineEdit,
    QMessageBox,
    QTableWidgetItem,
    QWidget,
)

from pstruct.configDiann import configDiann
from pwidget.addParamWidget import addParamWidget
from pwidget.UI_paramEditor import UI_paramEditor
from QT.settings import addSetting, getSectionContent, getSetting
from ressource import dianCfgTemplate

logging.basicConfig()
logging.root.setLevel(logging.NOTSET)
logging.basicConfig(level=logging.NOTSET)

logger = logging.getLogger(__name__)
FORMAT = "[%(filename)s:%(lineno)s - %(funcName)20s() ] %(message)s"
logging.basicConfig(format=FORMAT)
logger.setLevel(logging.INFO)


class paramEditor(QWidget):
    selectAcceptEvent = pyqtSignal(configDiann)

    def __init__(self, myconfigDiann):
        QWidget.__init__(self)
        self.ui = UI_paramEditor()
        self.ui.setupUi(self)
        self.ui.tableWidget.setColumnCount(3)

        self.ui.tableWidget.setHorizontalHeaderLabels(["parameter", "values", "action"])
        templateList = getSectionContent("template")
        templateList.insert(0, "")
        self.ui.templateChoice.addItems(templateList)
        if myconfigDiann is None:
            self.params = configDiann()
            self.isSaved = False
        else:
            self.params = myconfigDiann
            self.__addRows()
            self.isSaved = True

    # add param to table from configDiann
    def __addRows(self):
        paramDict = self.params.toDict()
        for param in paramDict.keys():
            row_count = self.ui.tableWidget.rowCount()
            self.ui.tableWidget.insertRow(row_count)
            self.ui.tableWidget.setItem(row_count, 0, QTableWidgetItem(param))
            self.ui.tableWidget.setItem(
                row_count, 1, QTableWidgetItem("; ".join(paramDict[param]))
            )
            self.ui.tableWidget.setItem(row_count, 2, QTableWidgetItem("Remove"))

    # accept button need logic
    def accept(self):
        logging.info("accept clicked")
        self.selectAcceptEvent.emit(self.params)
        self.hide()

    def saveCfg(self):
        options = QFileDialog.Options()
        options |= QFileDialog.DontUseNativeDialog
        fileName, _ = QFileDialog.getSaveFileName(
            self, "Save File", "", "Text Files(*.cfg)", options=options
        )
        logging.info(fileName)
        logging.info(type(fileName))
        if fileName:
            if ".cfg" in fileName:
                self.params.setCfgFilePath(fileName)
            else:
                fileName = fileName + ".cfg"
                self.params.setCfgFilePath(fileName)
            self.isSaved = True
            savedFile = open(self.params.getOriginalFile(), "w")
            savedFile.write(self.params.toCfg())
            savedFile.close()

    # reject button
    def reject(self):
        logging.info("reject clicked")
        self.close()
        return -1

    # addParam
    def addParam(self):
        logging.info("addParam clicked")
        self.newParam = addParamWidget(self)
        self.newParam.selectAcceptEvent.connect(self.newParamAdd)
        self.newParam.show()

    def newParamAdd(self, dictNewParam):
        logging.debug(dictNewParam)
        if dictNewParam["param"] == "var-mod":
            self.params.addParamWithArg(dictNewParam["param"], dictNewParam["arg"])
            column = 0
            for row in range(self.ui.tableWidget.rowCount()):
                _item = self.ui.tableWidget.item(row, column)
                if _item:
                    if _item.text() == "var-mod":
                        self.ui.tableWidget.setItem(
                            row,
                            1,
                            QTableWidgetItem(
                                "; ".join(self.params.toDict()["var-mod"])
                            ),
                        )

        elif self.params.hasParam(dictNewParam["param"]):
            message = f"The parameter {dictNewParam['param']}\n"
            message += f"is already define with {dictNewParam['arg']}"
            QMessageBox.critical(self, "Erreur", message, QMessageBox.Ok)
        else:
            if self.params.isParamWithArg(dictNewParam["param"]):
                self.params.addParamWithArg(dictNewParam["param"], dictNewParam["arg"])
            else:
                self.params.addParam(dictNewParam["param"])
            row_count = self.ui.tableWidget.rowCount()
            self.ui.tableWidget.insertRow(row_count)
            self.ui.tableWidget.setItem(
                row_count, 0, QTableWidgetItem(dictNewParam["param"])
            )
            self.ui.tableWidget.setItem(
                row_count, 1, QTableWidgetItem(dictNewParam["arg"])
            )
            self.ui.tableWidget.setItem(row_count, 2, QTableWidgetItem("Remove"))

    def modifyParam(self, row, column):
        _itemName = QTableWidgetItem()
        _itemValue = QTableWidgetItem()
        if column == 2:
            logging.info("remove cell clicked for row " + str(row))
            item = self.ui.tableWidget.item(row, 0)
            if item is not None:
                paramName = item.text()
                print(type(paramName))
                logging.info("param to remove is " + str(paramName))
                self.params.removeParam(paramName)
                self.ui.tableWidget.removeRow(row)
            else:
                logging.warning(f"No item found at row {row}, column 0")
        else:
            _itemName = self.ui.tableWidget.item(row, 0)
            _itemValue = self.ui.tableWidget.item(row, 1)
            if _itemName and _itemValue:
                if self.params.isParamWithArg(_itemName.text()):
                    logging.info(_itemName.text() + " : " + _itemValue.text())
                    selection, ok = QInputDialog.getText(
                        self,
                        "Modify Param",
                        "param to modify " + f" {_itemName.text()} ",
                        QLineEdit.Normal,
                        _itemValue.text(),
                    )
                    logging.info(str(ok) + " : ", selection)
                    if ok:
                        self.params.modifyArgForParam(
                            _itemName.text(), _itemValue.text(), selection
                        )
                        _itemValue.setText(selection)
                        self.ui.tableWidget.setItem(row, 1, _itemValue)

    def loadTemplate(self):
        template = self.ui.templateChoice.currentText()
        currentParam = configDiann()
        diannCfgTemplatePath = str(impresources.files(dianCfgTemplate))
        templateName = str(getSetting("template", template))
        fullPathTemplate = PathJoin(diannCfgTemplatePath, templateName)
        currentParam.readCfg(fullPathTemplate)
        self.params = currentParam
        if self.ui.tableWidget.rowCount() != 0:
            self.ui.tableWidget.setRowCount(0)
        self.__addRows()

    def loadCfg(self):
        cfgfile = QFileDialog.getOpenFileName(
            self,
            "Select a cfg file",
            getSetting("param", "cfgdir"),
            "DiannConfig file (*.cfg);" + ";all files (*.*)",
        )[0]
        if Pathisfile(cfgfile):
            logging.info(f"CfgFile : {cfgfile}")
            # self.myconfig = configDiann()
            self.params.readCfg(cfgfile)
            logging.debug(f"loaded info : {self.params.toJSON()}")
            if self.ui.tableWidget.rowCount() != 0:
                self.ui.tableWidget.setRowCount(0)
            self.__addRows()
            dirCfg = Pathdirname(cfgfile)
            addSetting("param", "cfgdir", dirCfg)
        else:
            logging.info(f"{cfgfile} does not exist.")

    @override
    def resizeEvent(self, event: QResizeEvent) -> None:
        super().resizeEvent(event)
        print("Widget resized to:", event.size())
        self.ui.gridLayoutWidget.resize(event.size())
