import logging

from PyQt5.QtCore import pyqtSignal
from PyQt5.QtWidgets import QMessageBox, QWidget

from pstatic.diannParam import PARAM
from pwidget.UI_addParamWidget import UI_addParamWidget

logging.basicConfig()
logging.root.setLevel(logging.NOTSET)
logging.basicConfig(level=logging.NOTSET)

logger = logging.getLogger(__name__)
FORMAT = "[%(filename)s:%(lineno)s - %(funcName)20s() ] %(message)s"
logging.basicConfig(format=FORMAT)
logger.setLevel(logging.INFO)


class addParamWidget(QWidget):
    selectAcceptEvent = pyqtSignal(dict)

    def __init__(self, parent):
        QWidget.__init__(self)
        self.parent = parent
        self.ui = UI_addParamWidget()
        self.ui.setupUi(self)
        self.ui.paramNameSelector.addItems(PARAM.keys())

    def accept(self):
        logging.info("accept clicked")
        param = self.ui.paramNameSelector.currentText()
        if PARAM[param]["arg"] == "" and self.ui.argumentEdit.text() != "":
            message = f"The parameter {param} does not accept argument\n"
            message += "It will be ignored"
            QMessageBox.critical(self, "Erreur", message, QMessageBox.Ok)
            self.ui.argumentEdit.setText("")
        logging.info(f"{param} : {self.ui.argumentEdit.text()}")
        self.selectAcceptEvent.emit(
            {
                "param": self.ui.paramNameSelector.currentText(),
                "arg": self.ui.argumentEdit.text(),
            }
        )
        self.close()

    def cancel(self):
        logging.info("cancel clicked")
        self.close()

    # combobox->itemData(combobox->currentIndex())
    def paramSelect(self):
        param = self.ui.paramNameSelector.currentText()
        logging.info(param)
        descr = f"Argument : {PARAM[param]['arg']}\n"
        descr += f"Description : {PARAM[param]['descr']}"
        self.ui.paramDescription.setText(descr)
