"""Class to store experiment information
contains a configDiann object
the list of raw files and database used by the process
and also a boolean to know if it's a libgen or not
"""

# Copyright (c) 2025 PAPPSO

__author__ = "Thierry Balliau <thierry.balliau@inrae.fr>"
__version__ = "0.1"


import logging

from pstruct.configDiann import configDiann

logging.basicConfig()
logging.root.setLevel(logging.NOTSET)
logging.basicConfig(level=logging.NOTSET)

logger = logging.getLogger(__name__)
FORMAT = "[%(filename)s:%(lineno)s - %(funcName)20s() ] %(message)s"
logging.basicConfig(format=FORMAT)
logger.setLevel(logging.INFO)


class experiment:

    def __init__(self, params=None):
        """! init function can used a known params object or not
        @params a param object defauilt is None
        """
        if params is not None:
            self.params[params.getOriginalFile()] = params
        else:
            self.params = dict()
        self.rawList = None
        self.fastaList = None

    def addParams(self, params):
        """! add parameter in dict params key is originalFile slot of object
        @params a param object to add
        """
        if params.getOriginalFile() in self.params.keys():
            logging.debug("parameter is already define. It will be replace")
            self.params[params.getOriginalFile()] = params
        else:
            self.params[params.getOriginalFile()] = params

    def setRawFiles(self, rawFiles):
        """! set rawfiles list in rawlist
        @rawFiles list of raw files to set
        """
        if self.rawList is not None:
            logging.debug("rawFiles is already define. It will be replace")
            self.rawList = rawFiles
        else:
            self.rawList

    def addRawFiles(self, rawFiles):
        """! add rawfiles list to rawlist test if raw exist before
        @rawFiles list of raw files to add
        """
        for rawFile in rawFiles:
            if rawFile not in self.rawList:
                self.rawList.append(rawFile)
            else:
                message = f"{rawFile} is already present in rawFileList.\n"
                message += "It will be ignored"
                logging.info(message)

    def removeRawFiles(self, rawFiles):
        """! remove rawfiles list from rawlist
        @rawFiles list of raw files to remove
        """
        for rawFile in rawFiles:
            if rawFile not in self.rawList:
                message = f"{rawFile} is not present in rawFileList.\n"
                message += "It will be ignored"
                logging.info(message)
            else:
                self.rawList.remove(rawFile)

    def setFastaFiles(self, fastafiles):
        """! set fastafiles to fastaList
        fastafiles list of fasta files to set
        """
        for fastaFile in fastafiles:
            if fastaFile not in self.fastaList:
                message = f"{fastaFile} is already present in fastaList.\n"
                message += "It will be ignored"
                logging.info(message)
            else:
                self.fastaList.remove(fastaFile)
