# function to manage slurm command not sure class was need
from QT.settings import getSetting

# sbatch script example

# #!/bin/bash
#
# #SBATCH -N 1            # number of nodes
# #SBATCH -c 8            # number of cores
# #SBATCH -t 0-01:00:00   # time in d-hh:mm:ss
# #SBATCH -p general      # partition
# #SBATCH -q public       # QOS
# #SBATCH -o slurm.%j.out # file to save job's STDOUT (%j = JobId)
# #SBATCH -e slurm.%j.err # file to save job's STDERR (%j = JobId)
# #SBATCH --mail-type=ALL # Send an e-mail when a job starts, stops, or fails
# #SBATCH --mail-user="%u@asu.edu"
# #SBATCH --export=NONE   # Purge the job-submitting shell environment
#
# #Load required software
# module load mamba/latest
#
# #Activate our enviornment
# source activate myEnv
#
# #Change to the directory of our script
# cd ~/myResearchDir/test01
#
# #Run the software/python script
# python myscript.py

#!/bin/bash
# Options SBATCH :

# SBATCH --job-name={{job_name}} # Nom du Job
# SBATCH --cpus-per-task={{request_cpus}}       # Allocation de N CPUs par tandem
# SBATCH --mincpus={{request_cpus}}              # nombre minimum de cpu par noeuds
# SBATCH --mail-type=END,FAIL,TIME_LIMIT        # Notification par email de la
# SBATCH --nodes=1         # nombre minimum de noeuds
# SBATCH --chdir={{ tmp_dir }}         # répertoire de travail
# SBATCH --mem={{request_mem}}
# Traitement

# module purge
# module load hpcw
# module load parallel

# only one tandemng job
# srun --mpi=none --ntasks=1 --nodes=1 {{ tandem_bin_path }} {{ tmp_dir }}/{{ tandem_input }} 2>{{ tmp_dir }}/{{ tandem_input }}.err 1>{{ tmp_dir }}/{{ tandem_input }}.out &
#
# wait


def generateSBATCHScript(job_name, outputDir, cfgFile):
    # srunBin = getSetting("slurm", "srunbin")
    mailType = getSetting("slurm", "mailtype")
    core = getSetting("slurm", "core")
    mem = getSetting("slurm", "mem")
    diannExe = getSetting("param", "diannbin")
    script = "#!/bin/bash\n"
    script += f"#SBATCH --job-name={job_name}   # Nom du Job\n"
    script += "#SBATCH --nodes=1            # number of nodes\n"
    script += f"#SBATCH --cpus-per-task={core}            # number of cores\n"
    script += f"#SBATCH --mincpus={core}            # number of cores\n"
    script += f"#SBATCH -mem={mem}            # memory usage\n"
    script += f"#SBATCH --mail-type={mailType} # send mails\n"
    script += f"# SBATCH --chdir={outputDir}         # répertoire de travail\n"
    script += "\n"
    script += "# module purge\n"
    script += "# module load hpcw\n"
    script += "# module load parallel\n"
    script += "\n"
    script += f"srun --mpi=none --ntasks=1 --nodes=1 {diannExe}"
    script += f"{outputDir}/{cfgFile} "
    script += f"2>{outputDir}/diannExe.err "
    script += f"1>{outputDir}/diannExe.out &\n"
    script += "wait\n"
    scriptFile = open(os.path.join(outputDir, f"slurmBatch_{job_name}.txt"), "w")
    scriptFile.write(script)
    return f"slurmBatch_{job_name}.txt"


def getCommandLine():
    srunBin = getSetting("slurm", "srunbin")
    mailType = getSetting("slurm", "mailtype")
    core = getSetting("slurm", "core")
    mem = getSetting("slurm", "mem")
    return f"{srunBin} --mail-type {mailType} -c {core} --mem={mem}"
