# set to define all available argument for diann

PARAM = {
    "about": {
        "arg": "",
        "descr": "display information with basic links and notices for this DIA-NN version",
    },
    "cal": {
        "arg": "[N]",
        "descr": "set the calibration mode, valid values are 0 (off), 1, 3, 5 and 7, default is 7",
    },
    "cal-channel": {
        "arg": "[channel name]",
        "descr": "specifies which channel to use for calibration: if there is a channel that is expected to produce good identification numbers in all samples, use this command to possibly improve calibration",
    },
    "channel-run-norm": {
        "arg": "",
        "descr": "normalisation of multiplexed samples will be performed in run-specific manner, i.e. to perform normalisation, for each precursor ion DIA-NN will sum the respective channels within each run and will normalise these sums across runs: use e.g. for protein turnover SILAC experiments",
    },
    "channel-spec-norm": {
        "arg": "",
        "descr": "normalisation of multiplexed samples will be performed in channel-specific manner, i.e. each channel in each run is treated as a separate sample to be normalised: use to analyse experiments wherein multiplexing of independent samples is used to boost throughput",
    },
    "channels": {
        "arg": "[channel 1]; [channel 2];",
        "descr": "... lists multiplexing channels, wherein each channel declaration has the form [channel] = [label group],[channel name],[sites],[mass1:mass2:...], wherein [sites] has the same syntax as for --var-mod and if N sites are listed, N masses are listed at the end of the channel declaration. The spectral library will be automatically split into multiple channels, for precursors bearing the [label group] modification. To add the latter to a label-free spectral library, can use --lib-fixed-mod, e.g. --fixed-mod SILAC,0.0,KR,label --lib-fixed-mod SILAC. See Multiplexing using plexDIA for usage examples. Currently, [label group] must be the same for all channels and the channels must be listed in such an order that the channel mass shifts are non-decreasing for each modification site.",
    },
    "clear-mods": {
        "arg": "",
        "descr": "makes DIA-NN 'forget' all built-in modification (PTM) names",
    },
    "cont-quant-exclude": {
        "arg": "[tag]",
        "descr": "peptides corresponding to protein sequence ids tagged with the specified tag will be excluded from normalisation as well as quantification of protein groups that do not include proteins with the tag",
    },
    "convert": {
        "arg": "",
        "descr": "makes DIA-NN convert the mass spec files to the .dia format. The files are either saved to the same location as the input files, or in the Temp/.dia dir, if it is specified (in the GUI or using the --temp option)",
    },
    "cut": {
        "arg": "[specificty 1],[specificity 2],...",
        "descr": 'specifies cleavage specificity for the in silico digest. Cleavage sites (pairs of amino acids) are listed separated by commas, \'*\' indicates any amino acid, and \'!\' indicates that the respective site will not be cleaved. Examples: "--cut K*,R*,!*P" - canonical tryptic specificity, "--cut " - digest disabled, "--cut ** --missed-cleavages 100" will make DIA-NN perform a non-specific digest (first do this for a single peptide length, to estimate the numbers of precursors generated)}[specificty 1],[specificity 2],... ',
    },
    "decoy-channel": {
        "arg": "[channel]",
        "descr": "specifies the decoy channel masses, wherein [channel] has the same syntax as for --channels",
    },
    "dg-keep-nterm": {
        "arg": "[N]",
        "descr": "do not change the first N residues when generating decoys, default N = 1",
    },
    "dg-keep-cterm": {
        "arg": "[N]",
        "descr": "do not change the last N residues when generating decoys, default N = 1",
    },
    "dg-min-shuffle": {
        "arg": "[X]",
        "descr": "aim for any fragment mass shift introduced by shuffling during decoy generation to exceed X in absolute value, default 5.0",
    },
    "dg-min-mut": {
        "arg": "[X]",
        "descr": "aim for the precursor mass shift during mutation during decoy generation to be at least X in absolute value, default 15.0",
    },
    "dg-max-mut": {
        "arg": "[X]",
        "descr": "aim for the precursor mass shift during mutation during decoy generation not to exceed X in absolute value, default 50.0",
    },
    "dir": {
        "arg": "[folder]",
        "descr": "specifies a folder containing raw files to be processed. All files in the folder must be in .raw, .wiff, .mzML or .dia format",
    },
    "dir-all": {"arg": "[folder]", "descr": "as --dir, but recursive over subfolders"},
    "direct-quant": {
        "arg": "",
        "descr": "disable QuantUMS and use legacy DIA-NN quantification algorithms instead, also disables channel-specific protein quantification when analysing multiplexed samples",
    },
    "dl-no-fr": {
        "arg": "",
        "descr": "when using the deep learning predictor, prediction of fragment intensities will not be performed",
    },
    "dl-no-im": {
        "arg": "",
        "descr": "when using the deep learning predictor, prediction of ion mobilities will not be performed",
    },
    "dl-no-rt": {
        "arg": "",
        "descr": "when using the deep learning predictor, prediction of retention times will not be performed",
    },
    "duplicate-proteins": {
        "arg": "",
        "descr": "instructs DIA-NN not to skip entries in the sequence database with duplicate IDs (while by default if several entries have the same protein ID, all but the first entry will be skipped)",
    },
    "export-quant": {
        "arg": "add fragment quantities, fragment IDs and quality information to the .parquet output report"
    },
    "ext": {
        "arg": "[string]",
        "descr": "adds a string to the end of each file name (specified with --f)",
    },
    "f": {
        "arg": "[file name]",
        "descr": "specifies a run to be analysed, use multiple --f commands to specify multiple runs",
    },
    "fasta": {
        "arg": "[file name]",
        "descr": "specifies a sequence database in FASTA format (full support for UniProt proteomes), use multiple --fasta commands to specify multiple databases",
    },
    "fasta-filter": {
        "arg": "[file name]",
        "descr": "only consider peptides matching the stripped sequences specified in the text file provided (one sequence per line), when processing a sequence database",
    },
    "fasta-search": {
        "arg": "",
        "descr": "instructs DIA-NN to perform an in silico digest of the sequence database",
    },
    "fixed-loss": {
        "arg": "[modification name],[loss mass],[modification sites]",
        "descr": "instructs DIA-NN to apply a neutral loss (i.e. subtract the specified mass) to each fragment ion containing the specified modification(s) on the specified sites, proportional to the number of such sites within the fragment; this functionality is highly experimental and untested, there should be no more than one --fixed-loss or --var-loss declaration",
    },
    "fixed-mod": {
        "arg": "[name],[mass],[sites],[optional: 'label']",
        "descr": "adds the modification name to the list of recognised names and specifies the modification as fixed. Same syntax as for --var-mod. Has an effect of (i) applying fixed modifications during FASTA digest or (ii) declaring fixed modifications that can be applied to a library with --lib-fixed-mod",
    },
    "force-swissprot": {
        "arg": "",
        "descr": "only consider SwissProt (i.e. marked with '>sp|') sequences when processing a sequence database",
    },
    "full-profiling": {
        "arg": "",
        "descr": "enable using empirical spectra for empirical library generation",
    },
    "full-unimod": {
        "arg": "",
        "descr": "loads the complete UniMod modification database and disables the automatic conversion of modification names to the UniMod format",
    },
    "gen-spec-lib": {
        "arg": "",
        "descr": "instructs DIA-NN to generate a spectral library",
    },
    "global-norm": {
        "arg": "",
        "descr": "instructs DIA-NN to use simple global normalisation instead of RT-dependent normalisation",
    },
    "high-acc": {
        "arg": "",
        "descr": "QuantUMS settings will be otimised for maximum accuracy, i.e. to minimise any ratio compression quantitative bias",
    },
    "ids-to-names": {
        "arg": "",
        "descr": "protein sequence ids will also be used as protein names and genes, any information on actual protein names or genes will be ignored",
    },
    "id-profiling": {
        "arg": "",
        "descr": "set the empirical library generation mode to IDs profiling",
    },
    "ignore-decoys": {
        "arg": "",
        "descr": "ignore decoys when loading a .parquet library",
    },
    "il-eq": {
        "arg": "",
        "descr": "when using the 'Reannotate' function, peptides will be matched to proteins while considering isoleucine and leucine equivalent",
    },
    "im-acc": {
        "arg": "[X]",
        "descr": "a parameter that should roughly correspond to the magnitude of observed IM value differences between different ion species matching the same precursor, default X = 0.02",
    },
    "im-model": {
        "arg": "[file]",
        "descr": "specifies the file containing the IM deep learning prediction model",
    },
    "im-prec": {
        "arg": "[X]",
        "descr": "a parameter that should roughly correspond to the magnitude of IM errors due to noise, default X = 0.01",
    },
    "im-window": {
        "arg": "[X]",
        "descr": "IM extraction window will not be less than the specified value",
    },
    "im-window-mul": {
        "arg": "[X]",
        "descr": "affects the IM window/tolerance, larger values result in larger IM extraction window, default X = 2.0",
    },
    "individual-mass-acc": {
        "arg": "",
        "descr": "mass accuracies, if set to automatic, will be determined independently for different runs",
    },
    "individual-reports": {
        "arg": "",
        "descr": "a separate output report will be created for each run",
    },
    "individual-windows": {
        "arg": "",
        "descr": "scan window, if set to automatic, will be determined independently for different runs",
    },
    "int-removal": {
        "arg": "",
        "descr": "0 disables the removal of interfering precursors, not recommended",
    },
    "lib": {
        "arg": "[file]",
        "descr": "specifies a spectral library. The use of multiple --lib commands (experimental) allows to load multiple libraries in .tsv format",
    },
    "lib-fixed-mod": {
        "arg": "[name]",
        "descr": "in silico applies a modification, previously declared using --fixed-mod, to a spectral library",
    },
    "loc-factor": {
        "arg": "[X]",
        "descr": "a factor affecting reported PTM localisation confidence, higher values result in higher confidence reported, default X = 40.0, valid range: 2.0 to 1000.0",
    },
    "loc-no-h3po4": {
        "arg": "",
        "descr": "DIA-NN will not generate fragments with H3PO4 losses to localise phosphosites",
    },
    "mass-acc": {"arg": "[N]", "descr": "sets the MS2 mass accuracy to N ppm"},
    "mass-acc-cal": {
        "arg": "[N]",
        "descr": "sets the mass accuracy used during the calibration phase of the search to N ppm (default is 100 ppm, which is adjusted automatically to lower values based on the data)",
    },
    "mass-acc-ms1": {"arg": "[N]", "descr": "sets the MS1 mass accuracy to N ppm"},
    "matrices": {"arg": "", "descr": "output quantities matrices"},
    "matrix-qvalue": {
        "arg": "[X]",
        "descr": "sets the q-value used to filter the output matrices",
    },
    "matrix-spec-q": {
        "arg": "[X]",
        "descr": "run-specific protein q-value filtering will be used, in addition to the global q-value filtering, when saving protein matrices. The ability to filter based on run-specific protein q-values, which allows to generate highly reliable data, is one of the advantages of DIA-NN",
    },
    "max-fr-mz": {
        "arg": "[N]",
        "descr": "sets the maximum precursor m/z for the in silico library generation or library-free search",
    },
    "max-pep-len": {
        "arg": "[N]",
        "descr": "sets the maximum precursor length for the in silico library generation or library-free search",
    },
    "max-pr-charge": {
        "arg": "[N]",
        "descr": "sets the maximum precursor charge for the in silico library generation or library-free search",
    },
    "max-pr-mz": {
        "arg": "[N]",
        "descr": "sets the maximum precursor m/z for the in silico library generation or library-free search",
    },
    "mbr-fix-settings": {
        "arg": "",
        "descr": "when using the 'Unrelated runs' option in combination with MBR, the same settings will be used to process all runs during the second MBR pass",
    },
    "met-excision": {
        "arg": "",
        "descr": "enables protein N-term methionine excision as variable modification for the in silico digest",
    },
    "min-cal": {
        "arg": "[N]",
        "descr": "provide a guidance to DIA-NN suggesting the minimum number of IDs to use for mass calibration",
    },
    "min-class": {
        "arg": "[N]",
        "descr": "provide a guidance to DIA-NN suggesting the minimum number of IDs to use for linear classifier training",
    },
    "min-corr": {
        "arg": "[X]",
        "descr": "forces DIA-NN to only consider peak group candidates with correlation scores at least X",
    },
    "min-fr": {
        "arg": "[N]",
        "descr": "specifies the minimum number of fragments per precursors in the spectral library being saved",
    },
    "min-fr-mz": {
        "arg": "[N]",
        "descr": "sets the minimum fragment m/z for the in silico library generation or library-free search",
    },
    "min-peak": {
        "arg": "",
        "descr": "sets the minimum peak height to consider. Must be 0.01 or greater",
    },
    "min-pep-len": {
        "arg": "[N]",
        "descr": "sets the minimum precursor length for the in silico library generation or library-free search",
    },
    "min-pr-charge": {
        "arg": "[N]",
        "descr": "sets the minimum precursor charge for the in silico library generation or library-free search",
    },
    "min-pr-mz": {
        "arg": "[N]",
        "descr": "sets the minimum precursor m/z for the in silico library generation or library-free search",
    },
    "missed-cleavages": {
        "arg": "[N]",
        "descr": "sets the maximum number of missed cleavages",
    },
    "mod": {
        "arg": "[name],[mass],[optional: 'label']",
        "descr": 'declares a modification name. Examples: "--mod UniMod:5,43.005814", "--mod SILAC-Lys8,8.014199,label"',
    },
    "no-batch-mode": {
        "arg": "",
        "descr": "disable batch mode, consequently, use all precursors for calibration",
    },
    "no-calibration": {
        "arg": "",
        "descr": "disables mass calibration, not recommended",
    },
    "no-cut-after-mod": {
        "arg": "[name]",
        "descr": "discard peptides generated via in silico cuts after residues bearing a particular modification",
    },
    "no-decoy-channel": {
        "arg": "",
        "descr": "disables the use of a decoy channel for channel q-value calculation",
    },
    "no-fragmentation": {
        "arg": "",
        "descr": "DIA-NN will not consider fragments other than included in the spectral library",
    },
    "no-fr-selection": {
        "arg": "",
        "descr": "the selection of fragments for quantification based on the quality assessment of the respective extracted chromatograms will be disabled",
    },
    "no-lib-filter": {
        "arg": "",
        "descr": "the input library will be used 'as is' without discarding fragments that might be harmful for the analysis; use with caution",
    },
    "no-maxlfq": {"arg": "", "descr": "disables MaxLFQ for protein quantification"},
    "no-ms1": {
        "arg": "",
        "descr": "do not consider MS1 data, use only during method optimisation to evaluate the impact of MS1 on the data quality",
    },
    "no-norm": {"arg": "", "descr": "disables cross-run normalisation"},
    "no-peptidoforms": {
        "arg": "",
        "descr": "disables automatic activation of peptidoform scoring when variable modifications are declared, not recommended",
    },
    "no-prot-inf": {
        "arg": "",
        "descr": "disables protein inference (that is protein grouping) - protein groups from the spectral library will be used instead",
    },
    "no-prot-norm": {"arg": "", "descr": "disable protein-level normalisation"},
    "no-quant-files": {
        "arg": "",
        "descr": "instructs DIA-NN not to save .quant files to disk and store them in memory instead",
    },
    "no-rt-norm": {"arg": "", "descr": "disable RT-dependent normalisation"},
    "no-rt-window": {"arg": "", "descr": "disables RT-windowed search"},
    "no-skyline": {"arg": "", "descr": "do not generate .skyline.speclib"},
    "no-stats": {"arg": "", "descr": "disables the generation of the stats file"},
    "no-swissprot": {
        "arg": "",
        "descr": "instruct DIA-NN not to give preference for SwissProt proteins when inferring protein groups",
    },
    "no-tims-scan": {
        "arg": "",
        "descr": "force processing of timsTOF .d acquisitions as dia-PASEF (i.e. not slice/diagonal), use this to process 'dia-PASEF' files that are wrongly recognised as Slice-PASEF by DIA-NN - this may happen e.g. if the files that have a single window within the frame split in several windows with identical m/z bounds but different IM ranges (not recommended)",
    },
    "original-mods": {
        "arg": "",
        "descr": "disables the automatic conversion of known modifications to the UniMod format names known to DIA-NN",
    },
    "out": {
        "arg": "[file name]",
        "descr": "specifies the name of the main output report. The names of all other report files will be derived from this one",
    },
    "out-lib": {
        "arg": "[file name]",
        "descr": "specifies the name of a spectral library to be generated",
    },
    "out-lib-copy": {
        "arg": "",
        "descr": "copies the spectral library used into the output folder",
    },
    "peak-boundary": {
        "arg": "[X]",
        "descr": "if the fragment or MS1 signal decays below its max / X, this is considered the boundary of the elution peak, affects among other algorithms the calculation of start/stop RT values reported in the main .parquet report",
    },
    "peak-translation": {
        "arg": "",
        "descr": "instructs DIA-NN to take advantage of the co-elution of isotopologues, when identifying and quantifying precursors; automatically activated when using --channels",
    },
    "peptidoforms": {"arg": "", "descr": "enables peptidoform confidence scoring"},
    "pg-level": {
        "arg": "[N]",
        "descr": "controls the protein inference mode, with 0 - isoforms, 1 - protein names (as in UniProt), 2 - genes",
    },
    "predict-n-frag": {
        "arg": "[N]",
        "descr": "specifies the maximum number of fragments predicted by the deep learning predictor, default value is 12",
    },
    "predictor": {
        "arg": "",
        "descr": "instructs DIA-NN to perform deep learning-based prediction of spectra, retention times and ion mobility values",
    },
    "prefix": {
        "arg": "[string]",
        "descr": "adds a string at the beginning of each file name (specified with --f) - convenient when working with automatic scripts for the generation of config files",
    },
    "prosit": {"arg": "", "descr": "export prosit input based on the FASTA digest"},
    "proteoforms": {
        "arg": "",
        "descr": "enables the proteoform confidence scoring mode",
    },
    "pr-filter": {
        "arg": "[file name]",
        "descr": "specify a file containing a list of precursors (same format as the Precursor.Id column in DIA-NN output), FASTA digest will be filtered to only include these precursors",
    },
    "qvalue": {
        "arg": "[X]",
        "descr": "specifies the precursor-level q-value filtering threshold",
    },
    "quant-acc": {
        "arg": "[X]",
        "descr": "sets the precision-accuracy balance for QuantUMS to X, where X must be between 0 and 1",
    },
    "quant-pep": {
        "arg": "[X]",
        "descr": "sets the posterior error probability threshold for precursor ions to be used for quantification: precursors not passing the threshold may be ignored by some algorithms of DIA-NN, default X value is 0.05",
    },
    "quant-ori-names": {
        "arg": "",
        "descr": ".quant files will retain original raw file names even if saved to a separate directory, convenient for .quant file manipulation",
    },
    "quant-fr": {
        "arg": "[N]",
        "descr": "sets the number of top fragment ions among which the fragments that will be used for quantification are chosen for the legacy (pre-QuantUMS) quantification mode. Default value is 6",
    },
    "quick-mass-acc": {
        "arg": "",
        "descr": "(experimental) when choosing the MS2 mass accuracy setting automatically, DIA-NN will use a fast heuristical algorithm instead of IDs number optimisation",
    },
    "quant-no-ms1": {
        "arg": "",
        "descr": "instructs QuantUMS not to use the recorded MS1 quantities directly",
    },
    "quant-params": {
        "arg": "[params]",
        "descr": "use previously obtained QuantUMS parameters",
    },
    "quant-sel-runs": {
        "arg": "[N]",
        "descr": "instructs QuantUMS to train its parameters on N automatically chosen runs, to speed up training for large experiments, N here must be 6 or greater",
    },
    "quant-tims-sum": {
        "arg": "",
        "descr": "for slice/scanning timsTOF methods, calculate intensities by taking the sum of all cognate signals across the cycle, as opposed to taking the maximum, use this for Synchro-PASEF",
    },
    "quant-train-runs": {
        "arg": "[N1]:[N2]",
        "descr": "instructs QuantUMS to train its parameters on runs with indices in the range N1 to N2 (inclusive), e.g. --quant-train-runs 0:5 will perform training on 6 runs with indices 0 to 5",
    },
    "read-threads": {
        "arg": "[N]",
        "descr": "use a particular number of CPU threads when reading raw files",
    },
    "reanalyse": {"arg": "", "descr": "enables MBR"},
    "reannotate": {
        "arg": "",
        "descr": "reannotate the spectral library with protein information from the FASTA database, using the specified digest specificity",
    },
    "ref": {
        "arg": "[file name]",
        "descr": "(experimental) specify a special (small) spectral library which will be used exclusively for calibration - this function can speed up calibration in library-free searches; this special library must have the same RT and IM scales as the main predicted/experimental library used for the analysis; use with caution",
    },
    "regular-swath": {
        "arg": "",
        "descr": "all runs will be analysed as if they were not Scanning SWATH runs",
    },
    "relaxed-prot-inf": {
        "arg": "",
        "descr": "use inference as in msfragger",
    },
    "report-decoys": {
        "arg": "",
        "descr": "save decoy PSMs to the main .parquet report",
    },
    "report-file-name": {
        "arg": "",
        "descr": "save the full run name, including the file path, to the main report",
    },
    "restrict-fr": {
        "arg": "",
        "descr": "some fragments will not be used for quantification, based on the value in the ExcludeFromAssay spectral library column; marking all fragments of a precursor as excluded will, together with --restrict-fr, suppress the use of this precursor for protein quantification whenever possible",
    },
    "rt-model": {
        "arg": "[file]",
        "descr": "specifies the file containing the RT deep learning prediction model",
    },
    "rt-profiling": {
        "arg": "",
        "descr": "set the empirical library generation mode to IDs, RT and IM profiling",
    },
    "rt-window": {
        "arg": "[X]",
        "descr": "RT extraction window will not be less than the specified value",
    },
    "rt-window-factor": {
        "arg": "[N]",
        "descr": "Affects the RT extraction window, set to higher values to enable narrow RT windows, default N = 40",
    },
    "rt-window-force": {
        "arg": "[X]",
        "descr": "RT extraction window will be set to the specified value",
    },
    "rt-window-mul": {
        "arg": "[X]",
        "descr": "Affects the RT extraction window, larger values result in larger window, decrease for faster analysis, default X = 2.5",
    },
    "scanning-swath": {
        "arg": "",
        "descr": "all runs will be analysed as if they were Scanning SWATH runs",
    },
    "semi": {
        "arg": "",
        "descr": "when using the 'Reannotate' function, a peptide will be matched to a protein also if it could be obtained with one specific and one non-specific cut (at either of the termini)",
    },
    "sig-norm": {
        "arg": "",
        "descr": "enable signal-dependent normalisation, not recommended",
    },
    "site-ms1-quant": {
        "arg": "",
        "descr": "use MS1 quantities for modification site quantification matrices",
    },
    "skip-unknown-mods": {
        "arg": "",
        "descr": "instructs DIA-NN to ignore peptides with modifications that are not supported by the deep learning predictor, when performing the prediction",
    },
    "smart-profiling": {
        "arg": "",
        "descr": "enables an intelligent algorithm which determines how to extract spectra, when creating a spectral library from DIA data, use with --full-profiling. The performance has so far always been observed to be comparable to IDs, RT and IM profiling",
    },
    "species-genes": {
        "arg": "",
        "descr": "instructs DIA-NN to add the organism identifier to the gene names - useful for distinguishing genes from different species, when analysing mixed samples. Works with UniProt sequence databases.",
    },
    "species-ids": {
        "arg": "",
        "descr": "instructs DIA-NN to add the organism identifier to the sequence ids/protein isoform ids - useful for distinguishing protein ids from different species, when analysing mixed samples. Works with UniProt sequence databases.",
    },
    "sptxt-acc": {
        "arg": "[N]",
        "descr": "sets the fragment filtering mass accuracy (in ppm) when reading .sptxt/.msp libraries",
    },
    "tag-to-ids": {
        "arg": "[tag]",
        "descr": "proteins that have the respective FASTA header start with tag (i.e. the string following '>' starts with tag) will have the tag incorporated in the respective protein sequence ids, names and genes",
    },
    "temp": {"arg": "[folder]", "descr": "specifies the Temp/.dia directory"},
    "threads": {"arg": "[N]", "descr": "specifies the number of CPU threads to use"},
    "time-corr-only": {
        "arg": "",
        "descr": "restrict machine learning during calibration",
    },
    "time-corr-only-force": {
        "arg": "",
        "descr": "restrict the use of machine learning for peak group selection during all search stages",
    },
    "tims-min-cnt": {
        "arg": "[N]",
        "descr": "specifies the minimum number of peaks to constitute a centroided peak when loading timsTOF data",
    },
    "tims-min-int": {
        "arg": "[N]",
        "descr": "specifies the minimum peak intensity (an integer ion count) to be considered when loading timsTOF data",
    },
    "tims-ms1-cycle": {
        "arg": "[N]",
        "descr": "merge the MS/MS spectra from N consecutive cycles, each cycle defined as the set of MS/MS scans following an MS1 scan, use this option only for slice/scanning timsTOF data and always test if the performance is better than without it",
    },
    "tokens": {
        "arg": "[file]",
        "descr": "specify the file name for the text file that contains a mapping between modified residues or N-term modifications and integers in the range 0-255, this file is used by the deep learning predictor",
    },
    "top": {
        "arg": "[N]",
        "descr": "set N for the top N protein quantification, default N = 1",
    },
    "tune-im": {
        "arg": "",
        "descr": "tune the IM deep learning predictor, requires --tune-lib",
    },
    "tune-lib": {
        "arg": "[file]",
        "descr": "specifies the library to be used for deep learning predictor fine-tuning, may require declaring unknown modifications with --mod",
    },
    "tune-lr": {
        "arg": "[X]",
        "descr": "specifies fine-tuning learning rate, default is 0.00001",
    },
    "tune-restrict-layers": {
        "arg": "",
        "descr": "keep RNN layer weights fixed when fine-tuning",
    },
    "tune-rt": {
        "arg": "",
        "descr": "tune the RT deep learning predictor, requires --tune-lib",
    },
    "use-quant": {"arg": "", "descr": "use existing .quant files, if available"},
    "verbose": {
        "arg": "[N]",
        "descr": "sets the level of detail of the log. Reasonable values are in the range 0 - 4",
    },
    "var-loss": {
        "arg": "[modification name],[loss mass],[modification sites]",
        "descr": "instructs DIA-NN to apply a neutral loss (i.e. subtract the specified mass) to each fragment ion containing the specified modification(s) on the specified sites, max 1 time regardless of the number of sites, and then append such modified fragments to the original list of fragments without losses; this functionality is highly experimental and untested, it is in particular not known how this can affect identification numbers; there should be no more than one --fixed-loss or --var-loss declaration",
    },
    "var-mod": {
        "arg": "[name],[mass],[sites],[optional: 'label']",
        "descr": "- adds the modification name to the list of recognised names and specifies the modification as variable. [sites] can contain a list of amino acids and 'n' which codes for the N-terminus of the peptide. '*n' indicates protein N-terminus. Examples: \"--var-mod UniMod:21,79.966331,STY\" - phosphorylation, \"--var-mod UniMod:1,42.010565,*n\" - N-terminal protein acetylation. Similar to --mod can be followed by 'label'. Has an effect of (i) applying variable modifications during FASTA digest or (ii) declaring modifications to be localised during raw data analysis",
    },
    "var-mods": {
        "arg": "[X]",
        "descr": "sets the maximum number of variable modifications",
    },
    "xic": {
        "arg": "[optional: X]",
        "descr": "instructs DIA-NN to extract MS1/fragment chromatograms for identified precursors within X seconds from the elution apex, with X set to 10s if not provided; the chromatograms are saved in .parquet files (one per run) located in a folder that is created in the same location as the main output report; equivalent to the 'XICs' option in the GUI",
    },
    "xic-theoretical-fr": {
        "arg": "",
        "descr": "makes DIA-NN extract chromatograms for all theoretical charge 1-2 fragment ions, including those with common neutral losses, if --xic is used",
    },
    "window": {
        "arg": "[N]",
        "descr": "sets the scan window radius to a specific value. Ideally, should be approximately equal to the average number of MS/MS data points per peak",
    },
}


paramnotAvailable = {
    "aff": {
        "arg": "M:K-N",
        "Descr": "(Enteprise version) attempt to set the CPU affinity of the main thread to logical core M and all other threads to logical cores K to N (core indices start with 0); consider using --aff when (i) running DIA-NN on NUMA HPC systems or (ii) running multiple DIA-NN analyses in parallel",
    },
    "auto-aff": {
        "arg": "",
        "descr": "(Enteprise version) attempt to automatically set thread affinities to spread CPU threads over logical CPU cores, first assigning to cores with even indices (starting with 0), to avoid placing two threads on a single physical core; this setting may be highly beneficial in particular on Windows systems with > 64 logical cores in a single CPU. On NUMA HPC systems, consider using --aff instead; when using --auto-aff, do not run any other DIA-NN analyses in parallel on the same PC",
    },
    "cfg": {
        "arg": "file name",
        "descr": "specifies a file to load options/commands from",
    },
}
