###! functions to store and use settings using qsettings

##
# structure of param is as following
# * directories section contains path to save json, or export can store always
# directory of input data like path to software and raw data
# * XIC contains mass to extract
# * param contains parameters to extract XIC


from configparser import ConfigParser
from importlib import resources as impresources

# Imports
# from PyQt5.QtWidgets import *
from PyQt5.QtCore import QSettings

import ressource


# Functions
def init():
    """! test if param exist and initiate it if not.

    @return status of existence of settings 0 if setted -1 if not

    """

    settings = QSettings("PAPPSO", "DiaCmdBuilder")
    settings.beginGroup("param")
    if len(settings.allKeys()) == 0:
        print("First opening of program : initiating values")
        configur = ConfigParser()
        # Convertir le Traversable en chemin de fichier compatible
        param_ini_path = str(impresources.files(ressource) / "param.ini")
        print(configur.read(param_ini_path))
        settings.endGroup()
        print("creation of settings from ini file")
        print(f"List of section in ini file : {configur.sections()}")
        for section in configur.sections():
            settings.beginGroup(section)
            for key in configur.items(section):
                print(
                    f"Create {key} with {configur.get(section, key[0])} in section {section}"
                )
                addSetting(section, key[0], configur.get(section, key[0]))
            settings.endGroup()
        return -1
    # else:
    #     configur = ConfigParser()
    #     # Convertir le Traversable en chemin de fichier compatible
    #     param_ini_path = str(impresources.files(ressource) / "param.ini")
    #     print(configur.read(param_ini_path))
    #     settings.endGroup()
    #     print("Verification of concordance of settings between reg and ini file")
    #     print(f"List of section in registry : {settings.allKeys()}")
    #     print(f"List of section in ini file : {configur.sections()}")
    #     for section in configur.sections():
    #         settings.beginGroup(section)
    #         print(f"verify parameter for {section} section")
    #         for key in configur.items(section):
    #             print(f"verify {key[0]} in {section} section")
    #             if key[0] in settings.allKeys():
    #                 # print(f"{settings.value( key[0])} :  {configur.get(section,  key[0])}")
    #                 # print(f"{type(settings.value( key[0]))} :  {type(configur.get(section,  key[0]))}")
    #                 if settings.value(key[0]) != configur.get(section, key[0]):
    #                     print(f"updating {key[0]} parameter in {section}")
    #                     addSetting(section, key[0], configur.get(section, key[0]))
    #             else:
    #                 print(f"parameter {key[0]} is not present in {section}. Create it")
    #                 addSetting(section, key[0], configur.get(section, key[0]))
    #                 # print(f"{key[0]} as {type(key[0])} not present in {section} section")
    #         settings.endGroup()
    #     return 0


def addSetting(section, setting, value):
    """! add setting to the giving section if setting exist print the previous value

    @param section  The section of setting as string
    @param setting  The setting name as string
    @param value    The value to set as variable

    """

    settings = QSettings("PAPPSO", "DiaCmdBuilder")
    settings.beginGroup(section)
    if settings.contains(setting):
        print(
            f"Previous setting value for {section}:{setting} is {settings.value(setting)}.\nReplacing it by {value}."
        )
        settings.setValue(setting, value)
    else:
        print(f"No value setted for {section}:{setting}.\nSet {value} to it.")
        settings.setValue(setting, value)
    settings.endGroup()
    settings.sync()


def getSetting(section, setting):
    """! get value for given setting in the given section

    @param section  The section of setting as string
    @param setting  The setting name as string

    @return setting or None if is not exist

    """
    settings = QSettings("PAPPSO", "DiaCmdBuilder")
    settings.beginGroup(section)
    if settings.contains(setting):
        return settings.value(setting)
    else:
        return None


def getSectionContent(section):
    """! get sezttings for given section

    @param section  The section of setting as string
    @return list a settings in section

    """
    settings = QSettings("PAPPSO", "DiaCmdBuilder")
    settings.beginGroup(section)
    return settings.allKeys()
